/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.aesh.command.shell.Shell;
import org.aesh.terminal.Connection;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.impl.AeshDelegatingShell;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.functional.AbstractMultiClusterIT;
import org.infinispan.server.test.core.AeshTestConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CliBackupManagerIT
extends AbstractMultiClusterIT {
    static final File WORKING_DIR = new File(CommonsTestingUtil.tmpDirectory(CliBackupManagerIT.class));

    public CliBackupManagerIT() {
        super("configuration/ClusteredServerTest.xml");
    }

    @Before
    public void setup() {
        WORKING_DIR.mkdirs();
    }

    @Override
    @After
    public void cleanup() throws Exception {
        super.cleanup();
        Util.recursiveFileRemove((File)WORKING_DIR);
    }

    @Test
    public void testPartialBackup() throws Exception {
        this.startSourceCluster();
        String backupName = "partial-backup";
        String fileName = backupName + ".zip";
        try (AeshTestConnection t = this.cli(this.source);){
            t.readln("backup create --templates=* -n " + backupName);
            t.readln("backup get --no-content " + backupName);
        }
        Path createdBackup = this.source.driver.getRootDir().toPath().resolve("0/data/backups").resolve(backupName).resolve(fileName);
        try (ZipFile zip = new ZipFile(createdBackup.toFile());){
            Assert.assertNotNull((Object)this.zipResourceDir(BackupManager.Resources.Type.TEMPLATES));
            this.assertResourceDoesntExist(zip, BackupManager.Resources.Type.CACHES, BackupManager.Resources.Type.COUNTERS, BackupManager.Resources.Type.PROTO_SCHEMAS, BackupManager.Resources.Type.TASKS);
        }
        Files.delete(createdBackup);
    }

    private void assertResourceDoesntExist(ZipFile zip, BackupManager.Resources.Type ... types) {
        for (BackupManager.Resources.Type type : types) {
            String dir = this.zipResourceDir(type);
            Assert.assertNull((Object)zip.getEntry(dir));
        }
    }

    private String zipResourceDir(BackupManager.Resources.Type type) {
        return "containers/default/" + type.toString();
    }

    @Test
    public void testBackupToCustomDir() throws Exception {
        this.startSourceCluster();
        String backupName = "server-backup";
        String fileName = backupName + ".zip";
        File backupDir = new File(WORKING_DIR, "custom-dir");
        backupDir.mkdir();
        try (AeshTestConnection t = this.cli(this.source);){
            t.clear();
            t.readln(String.format("backup create -d %s -n %s", backupDir.getPath(), backupName));
            t.readln("backup get --no-content " + backupName);
        }
        Assert.assertTrue((boolean)new File(backupDir, backupName + "/" + fileName).exists());
    }

    @Test
    public void testBackupFromServerDir() throws Exception {
        this.startSourceCluster();
        String backupName = "server-backup";
        String fileName = backupName + ".zip";
        try (AeshTestConnection t = this.cli(this.source);){
            t.readln("create cache --template=org.infinispan.DIST_SYNC backupCache");
            t.readln("cd caches/backupCache");
            t.readln("put k1 v1");
            t.readln("ls");
            t.assertContains("k1");
            t.clear();
            t.readln("backup create -n " + backupName);
            t.readln("backup get --no-content " + backupName);
        }
        this.stopSourceCluster();
        this.startTargetCluster();
        Path createdBackup = this.source.driver.getRootDir().toPath().resolve("0/data/backups").resolve(backupName).resolve(fileName);
        try (AeshTestConnection t = this.cli(this.target);){
            t.readln("backup restore " + createdBackup.toString());
            Thread.sleep(1000L);
            t.readln("ls caches/backupCache");
            t.assertContains("k1");
        }
        Files.delete(createdBackup);
    }

    @Test
    public void testBackupUpload() throws Exception {
        Path createdBackup;
        this.startSourceCluster();
        try (AeshTestConnection t = this.cli(this.source);){
            t.readln("create cache --template=org.infinispan.DIST_SYNC backupCache");
            t.readln("cd caches/backupCache");
            t.readln("put k1 v1");
            t.readln("ls");
            t.assertContains("k1");
            t.clear();
            String backupName = "example-backup";
            t.readln("backup create -n " + backupName);
            t.readln("backup get " + backupName);
            Thread.sleep(1000L);
            t.readln("backup delete " + backupName);
            String fileName = backupName + ".zip";
            createdBackup = Paths.get(System.getProperty("user.dir"), new String[0]).resolve(fileName);
        }
        this.stopSourceCluster();
        this.startTargetCluster();
        t = this.cli(this.target);
        try {
            t.readln("backup restore -u " + createdBackup);
            Thread.sleep(1000L);
            t.readln("ls caches/backupCache");
            t.assertContains("k1");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        Files.delete(createdBackup);
    }

    private AeshTestConnection cli(AbstractMultiClusterIT.Cluster cluster) {
        AeshTestConnection t = new AeshTestConnection();
        CLI.main((Shell)new AeshDelegatingShell((Connection)t), (String[])new String[0], (Properties)new Properties());
        String host = cluster.driver.getServerAddress(0).getHostAddress();
        int port = cluster.driver.getServerSocket(0, 11222).getPort();
        t.readln(String.format("connect %s:%d", host, port));
        t.assertContains("//containers/default]>");
        t.clear();
        return t;
    }
}

