/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.concurrent.ExecutionException;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class MemcachedOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testMemcachedOperations() {
        MemcachedClient cache = this.SERVER_TEST.getMemcachedClient();
        cache.set("k1", 0, (Object)"v1");
        Assert.assertEquals((Object)"v1", (Object)cache.get("k1"));
    }

    @Test
    public void testSetGetNewLineChars() {
        MemcachedClient cache = this.SERVER_TEST.getMemcachedClient();
        cache.set("a", 0, (Object)"A\r\nA");
        Assert.assertEquals((Object)"A\r\nA", (Object)cache.get("a"));
    }

    @Test
    public void testFlush() throws Exception {
        MemcachedClient cache = this.SERVER_TEST.getMemcachedClient();
        cache.set("k1", 0, (Object)"v1");
        cache.set("k2", 0, (Object)"v2");
        Assert.assertTrue((boolean)((Boolean)cache.flush().get()));
        Assert.assertNull((Object)cache.get("k1"));
        Assert.assertNull((Object)cache.get("k2"));
    }

    @Test
    public void testPutAsync() throws ExecutionException, InterruptedException {
        MemcachedClient cache = this.SERVER_TEST.getMemcachedClient();
        OperationFuture key1 = cache.add("k1", 10, (Object)"v1");
        Assert.assertTrue((boolean)((Boolean)key1.get()));
        Assert.assertEquals((Object)"v1", (Object)cache.get("k1"));
        Assert.assertNull((Object)cache.get("nonExistentkey"));
    }

    @Test
    public void testNonExistentkey() throws ExecutionException, InterruptedException {
        MemcachedClient cache = this.SERVER_TEST.getMemcachedClient();
        Assert.assertNull((Object)cache.get("nonExistentkey"));
    }
}

