/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.server.persistence.PersistenceIT;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.category.Persistence;
import org.infinispan.server.test.core.persistence.Database;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={Persistence.class})
@RunWith(value=Parameterized.class)
public class PooledConnectionOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = PersistenceIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final Database database;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        String[] databaseTypes = PersistenceIT.DATABASE.getDatabaseTypes();
        ArrayList<Object[]> params = new ArrayList<Object[]>(databaseTypes.length);
        for (String databaseType : databaseTypes) {
            params.add(new Object[]{databaseType});
        }
        return params;
    }

    public PooledConnectionOperations(String databaseType) {
        this.database = PersistenceIT.DATABASE.getDatabase(databaseType);
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).fetchPersistentState(false)).ignoreModifications(false)).purgeOnStartup(false)).shared(false)).table().dropOnExit(true)).createOnStart(true)).tableNamePrefix("TBL")).idColumnName("ID")).idColumnType(this.database.getIdColumType())).dataColumnName("DATA")).dataColumnType(this.database.getDataColumnType())).timestampColumnName("TS")).timestampColumnType(this.database.getTimeStampColumnType())).segmentColumnName("S")).segmentColumnType(this.database.getSegmentColumnType())).connectionPool().connectionUrl(this.database.jdbcUrl()).username(this.database.username()).password(this.database.password()).driverClass(this.database.driverClassName());
        return builder;
    }

    @Test
    public void testTwoCachesSameCacheStore() {
        RemoteCache cache1 = ((HotRodTestClientDriver)((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(this.createConfigurationBuilder())).withQualifier("1")).create();
        RemoteCache cache2 = ((HotRodTestClientDriver)((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(this.createConfigurationBuilder())).withQualifier("2")).create();
        cache1.put((Object)"k1", (Object)"v1");
        String firstK1 = (String)cache1.get((Object)"k1");
        Assert.assertEquals((Object)"v1", (Object)firstK1);
        Assert.assertNull((Object)cache2.get((Object)"k1"));
        cache2.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)"v2", (Object)cache2.get((Object)"k2"));
        Assert.assertNull((Object)cache1.get((Object)"k2"));
        this.assertCleanCacheAndStore(cache1);
        this.assertCleanCacheAndStore(cache2);
    }

    @Test
    public void testPutGetRemove() {
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(this.createConfigurationBuilder())).create();
        cache.put((Object)"k1", (Object)"v1");
        cache.put((Object)"k2", (Object)"v2");
        Assert.assertNotNull((Object)cache.get((Object)"k1"));
        Assert.assertNotNull((Object)cache.get((Object)"k2"));
        cache.stop();
        cache.start();
        Assert.assertNotNull((Object)cache.get((Object)"k1"));
        Assert.assertNotNull((Object)cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
        Assert.assertEquals((Object)"v2", (Object)cache.get((Object)"k2"));
        cache.remove((Object)"k1");
        Assert.assertNull((Object)cache.get((Object)"k1"));
    }

    protected void assertCleanCacheAndStore(RemoteCache cache) {
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
    }
}

