/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authorization;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.security.VoidCallbackHandler;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.server.security.authorization.AbstractAuthorization;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.LdapServerListener;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class AuthorizationKerberosIT
extends AbstractAuthorization {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/AuthorizationKerberosTest.xml").numServers(1)).property("java.security.krb5.conf", "${infinispan.server.config.path}/krb5.conf")).addListener((InfinispanServerListener)new LdapServerListener("ldif/infinispan-kerberos.ldif", true))).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private static String oldKrb5Conf;

    @BeforeClass
    public static void setKrb5Conf() {
        oldKrb5Conf = System.setProperty("java.security.krb5.conf", AuthorizationKerberosIT.class.getClassLoader().getResource("configuration/krb5.conf").getPath());
    }

    @AfterClass
    public static void restoreKrb5Conf() {
        if (oldKrb5Conf != null) {
            System.setProperty("java.security.krb5.conf", oldKrb5Conf);
        }
    }

    @Override
    protected InfinispanServerRule getServers() {
        return SERVERS;
    }

    @Override
    protected InfinispanServerTestMethodRule getServerTest() {
        return this.SERVER_TEST;
    }

    @Override
    protected void addClientBuilders(TestUser user) {
        ConfigurationBuilder hotRodBuilder = new ConfigurationBuilder();
        Subject subject = Common.createSubject(user.getUser(), "INFINISPAN.ORG", user.getPassword().toCharArray());
        hotRodBuilder.security().authentication().saslMechanism("GSSAPI").serverName("datagrid").realm("default").callbackHandler((CallbackHandler)new VoidCallbackHandler()).clientSubject(subject);
        this.hotRodBuilders.put(user, hotRodBuilder);
        RestClientConfigurationBuilder restBuilder = new RestClientConfigurationBuilder();
        restBuilder.security().authentication().mechanism("SPNEGO").clientSubject(subject);
        this.restBuilders.put(user, restBuilder);
    }
}

