/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.persistence.JdbcConfigurationUtil;
import org.infinispan.server.persistence.PersistenceIT;
import org.infinispan.server.persistence.TableManipulation;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.category.Persistence;
import org.infinispan.server.test.core.persistence.Database;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={Persistence.class})
@RunWith(value=Parameterized.class)
public class JdbcStringBasedCacheStorePassivation {
    @ClassRule
    public static InfinispanServerRule SERVERS = PersistenceIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final Database database;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        String[] databaseTypes = PersistenceIT.DATABASE.getDatabaseTypes();
        ArrayList<Object[]> params = new ArrayList<Object[]>(databaseTypes.length);
        for (String databaseType : databaseTypes) {
            params.add(new Object[]{databaseType});
        }
        return params;
    }

    public JdbcStringBasedCacheStorePassivation(String databaseType) {
        this.database = PersistenceIT.DATABASE.getDatabase(databaseType);
    }

    @Test
    public void testFailover() throws Exception {
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(CacheMode.REPL_SYNC, this.database, false, true).setLockingConfigurations();
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(jdbcUtil.getConfigurationBuilder())).create();
        try (TableManipulation table = new TableManipulation(cache.getName(), jdbcUtil.getPersistenceConfiguration(), jdbcUtil.getConfigurationBuilder());){
            cache.put((Object)"k1", (Object)"v1");
            cache.put((Object)"k2", (Object)"v2");
            Assert.assertNotNull((Object)table.getValueByKey("k1"));
            Assert.assertNotNull((Object)table.getValueByKey("k2"));
            SERVERS.getServerDriver().stop(0);
            SERVERS.getServerDriver().restart(0);
            Assert.assertNotNull((Object)table.getValueByKey("k1"));
            Assert.assertNotNull((Object)table.getValueByKey("k2"));
            Assert.assertNull((Object)cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).get((Object)"k3"));
            Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
            Assert.assertEquals((Object)"v2", (Object)cache.get((Object)"k2"));
            cache.remove((Object)"k1");
            Assert.assertNull((Object)table.getValueByKey("k1"));
            cache.clear();
        }
    }

    @Test
    public void testPreload() throws Exception {
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(CacheMode.REPL_SYNC, this.database, false, true).setLockingConfigurations();
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(jdbcUtil.getConfigurationBuilder())).create();
        try (TableManipulation table = new TableManipulation(cache.getName(), jdbcUtil.getPersistenceConfiguration(), jdbcUtil.getConfigurationBuilder());){
            cache.clear();
            cache.put((Object)"k1", (Object)"v1");
            cache.put((Object)"k2", (Object)"v2");
            Assert.assertNotNull((Object)table.getValueByKey("k1"));
            Assert.assertNotNull((Object)table.getValueByKey("k2"));
            SERVERS.getServerDriver().stop(0);
            SERVERS.getServerDriver().restart(0);
            Assert.assertEquals((long)2L, (long)cache.size());
            Assert.assertNotNull((Object)table.getValueByKey("k1"));
            Assert.assertNotNull((Object)table.getValueByKey("k2"));
        }
    }

    @Test
    public void testDefaultTwoWayKey2StringMapper() throws Exception {
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(CacheMode.REPL_SYNC, this.database, false, true).setLockingConfigurations();
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(jdbcUtil.getConfigurationBuilder())).create();
        try (TableManipulation table = new TableManipulation(cache.getName(), jdbcUtil.getPersistenceConfiguration(), jdbcUtil.getConfigurationBuilder());){
            Double doubleKey = 10.0;
            Double doubleValue = 20.0;
            Assert.assertEquals((long)0L, (long)cache.size());
            Assert.assertTrue((table.countAllRows() == 0 ? 1 : 0) != 0);
            cache.put((Object)doubleKey, (Object)doubleValue);
            Assert.assertEquals((long)1L, (long)table.countAllRows());
            Assert.assertEquals((Object)doubleValue, (Object)cache.get((Object)doubleKey));
        }
    }

    @Test
    public void testSoftRestartWithPassivation() throws Exception {
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(CacheMode.REPL_SYNC, this.database, true, false).setEvition().setLockingConfigurations();
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(jdbcUtil.getConfigurationBuilder())).create();
        try (TableManipulation table = new TableManipulation(cache.getName(), jdbcUtil.getPersistenceConfiguration(), jdbcUtil.getConfigurationBuilder());){
            cache.put((Object)"k1", (Object)"v1");
            cache.put((Object)"k2", (Object)"v2");
            Assert.assertTrue((table.getValueByKey("k1") == null ? 1 : 0) != 0);
            Assert.assertTrue((table.getValueByKey("k2") == null ? 1 : 0) != 0);
            cache.put((Object)"k3", (Object)"v3");
            Assert.assertTrue((2 == this.getNumberOfEntriesInMemory(cache.getName()) ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)table.countAllRows());
            SERVERS.getServerDriver().stop(0);
            SERVERS.getServerDriver().restart(0);
            Assert.assertEquals((long)0L, (long)this.getNumberOfEntriesInMemory(cache.getName()));
            Assert.assertEquals((long)3L, (long)table.countAllRows());
            Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
        }
    }

    @Test
    public void testFailoverWithPassivation() throws Exception {
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(CacheMode.REPL_SYNC, this.database, true, false).setEvition().setLockingConfigurations();
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(jdbcUtil.getConfigurationBuilder())).create();
        try (TableManipulation table = new TableManipulation(cache.getName(), jdbcUtil.getPersistenceConfiguration(), jdbcUtil.getConfigurationBuilder());){
            cache.put((Object)"k1", (Object)"v1");
            cache.put((Object)"k2", (Object)"v2");
            Assert.assertTrue((table.getValueByKey("k1") == null ? 1 : 0) != 0);
            Assert.assertTrue((table.getValueByKey("k2") == null ? 1 : 0) != 0);
            cache.put((Object)"k3", (Object)"v3");
            Assert.assertTrue((2 == this.getNumberOfEntriesInMemory(cache.getName()) ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)table.countAllRows());
            SERVERS.getServerDriver().kill(0);
            SERVERS.getServerDriver().restart(0);
            Assert.assertEquals((long)0L, (long)this.getNumberOfEntriesInMemory(cache.getName()));
            Assert.assertEquals((long)1L, (long)table.countAllRows());
            Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
        }
    }

    private int getNumberOfEntriesInMemory(String cacheName) {
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(new RestClientConfigurationBuilder()).get();
        RestResponse response = (RestResponse)Common.sync(client.cache(cacheName).stats());
        Json jsonNode = Json.read((String)response.getBody());
        return jsonNode.at("current_number_of_entries_in_memory").asInteger();
    }
}

