/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.List;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestLoggingResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testListLoggers() {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        Json loggers = Json.read((String)response.getBody());
        Assert.assertTrue((loggers.asJsonList().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListAppenders() {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse response = (RestResponse)Common.sync(client.server().logging().listAppenders());
        String body = response.getBody();
        Json appenders = Json.read((String)body);
        Assert.assertEquals((String)body, (long)5L, (long)appenders.asMap().size());
    }

    @Test
    public void testManipulateLogger() {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse response = (RestResponse)Common.sync(client.server().logging().setLogger("org.infinispan.TESTLOGGER", "WARN", new String[]{"STDOUT"}));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        Assert.assertTrue((String)"Logger not found", (boolean)this.findLogger(response, "org.infinispan.TESTLOGGER", "WARN", "STDOUT"));
        response = (RestResponse)Common.sync(client.server().logging().setLogger("org.infinispan.TESTLOGGER", "ERROR", new String[]{"FILE"}));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        Assert.assertTrue((String)"Logger not found", (boolean)this.findLogger(response, "org.infinispan.TESTLOGGER", "ERROR", "FILE"));
        response = (RestResponse)Common.sync(client.server().logging().removeLogger("org.infinispan.TESTLOGGER"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        Assert.assertFalse((String)"Logger should not be found", (boolean)this.findLogger(response, "org.infinispan.TESTLOGGER", "ERROR", new String[0]));
    }

    private boolean findLogger(RestResponse response, String name, String level, String ... appenders) {
        Json loggers = Json.read((String)response.getBody());
        for (int i = 0; i < loggers.asJsonList().size(); ++i) {
            Json logger = loggers.at(i);
            if (!name.equals(logger.at("name").asString())) continue;
            Assert.assertEquals((Object)level, (Object)logger.at("level").asString());
            List loggerAppenders = logger.at("appenders").asJsonList();
            Assert.assertEquals((long)appenders.length, (long)loggerAppenders.size());
            for (int j = 0; j < appenders.length; ++j) {
                Assert.assertEquals((Object)appenders[j], (Object)((Json)loggerAppenders.get(j)).asString());
            }
            return true;
        }
        return false;
    }
}

