/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.upgrade.SerializationUtils;
import org.infinispan.server.functional.RollingUpgradeIT;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.Assert;
import org.junit.Test;

public class RollingUpgradeDynamicStoreIT
extends RollingUpgradeIT {
    static final ParserRegistry parserRegistry = new ParserRegistry();

    public RollingUpgradeDynamicStoreIT() {
        super("configuration/ClusteredServerTest.xml");
    }

    @Override
    @Test
    public void testRollingUpgrade() throws Exception {
        RestClient restClientSource = this.source.getClient();
        RestClient restClientTarget = this.target.getClient();
        this.createSourceClusterCache();
        this.createTargetClusterWithoutStore();
        this.addSchema(restClientSource);
        this.addSchema(restClientTarget);
        this.populateCluster(restClientSource);
        this.connectTargetCluster();
        Assert.assertEquals((Object)"name-13", (Object)this.getPersonName("13", restClientTarget));
        this.doRollingUpgrade(restClientTarget);
        this.doRollingUpgrade(restClientTarget);
        this.disconnectSource(restClientTarget);
        this.stopSourceCluster();
        for (int i = 0; i < this.target.getMembers().size(); ++i) {
            RestClient restClient = this.target.getClient(i);
            Assert.assertEquals((long)50L, (long)this.getCacheSize("rolling", restClient));
            Assert.assertEquals((Object)"name-35", (Object)this.getPersonName("35", restClient));
        }
    }

    private void createTargetClusterWithoutStore() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.createCache("rolling", builder, this.target.getClient());
    }

    protected void connectTargetCluster() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.addRemoteStore(builder);
        RemoteStoreConfiguration remoteStore = (RemoteStoreConfiguration)builder.build().persistence().stores().iterator().next();
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)SerializationUtils.toJson((RemoteStoreConfiguration)remoteStore));
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)this.target.getClient().cache("rolling").connectSource(restEntity));
        Assert.assertEquals((String)response.getBody(), (long)204L, (long)response.getStatus());
    }
}

