/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.server.extensions.ExtensionsIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ServerTasks {
    @ClassRule
    public static final InfinispanServerRule SERVERS = ExtensionsIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testServerTaskNoParameters() {
        RemoteCache cache = this.SERVER_TEST.hotrod().create();
        Object hello = cache.execute("hello", Collections.emptyMap());
        Assert.assertEquals((Object)"Hello world", (Object)hello);
    }

    @Test
    public void testServerTaskWithParameters() {
        RemoteCache cache = this.SERVER_TEST.hotrod().create();
        ArrayList messages = (ArrayList)cache.execute("hello", Collections.singletonMap("greetee", new ArrayList<String>(Arrays.asList("nurse", "kitty"))));
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertEquals((Object)"Hello nurse", messages.get(0));
        Assert.assertEquals((Object)"Hello kitty", messages.get(1));
    }

    @Test
    public void testDistributedServerTaskWithParameters() {
        RemoteCache cache = this.SERVER_TEST.hotrod().withMarshaller(GenericJBossMarshaller.class).create();
        List greetings = (List)cache.execute("dist-hello", Collections.singletonMap("greetee", "my friend"));
        Assert.assertEquals((long)2L, (long)greetings.size());
        for (String greeting : greetings) {
            Assert.assertTrue((boolean)greeting.matches("Hello my friend .*"));
        }
    }
}

