/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.multimap.MetadataCollection;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCacheManagerFactory;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class HotRodMultiMapOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testMultiMap() {
        RemoteMultimapCache people = this.multimapCache();
        CompletableFuture elaia = people.put((Object)1, (Object)"Elaia");
        people.put((Object)1, (Object)"Oihana").join();
        elaia.join();
        Collection littles = (Collection)people.get((Object)1).join();
        Assert.assertEquals((long)2L, (long)littles.size());
        Assert.assertTrue((boolean)littles.contains("Elaia"));
        Assert.assertTrue((boolean)littles.contains("Oihana"));
    }

    @Test
    public void testPutWithDuplicates() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        multimapCache.put((Object)"k", (Object)"a").join();
        multimapCache.put((Object)"k", (Object)"a").join();
        multimapCache.put((Object)"k", (Object)"a").join();
        Collection kValues = (Collection)multimapCache.get((Object)"k").join();
        Assert.assertEquals((long)1L, (long)kValues.size());
        Assert.assertTrue((boolean)kValues.contains("a"));
    }

    @Test
    public void testGetWithMetadata() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        multimapCache.put((Object)"k", (Object)"a").join();
        MetadataCollection metadataCollection = (MetadataCollection)multimapCache.getWithMetadata((Object)"k").join();
        Assert.assertEquals((long)1L, (long)metadataCollection.getCollection().size());
        Assert.assertTrue((boolean)metadataCollection.getCollection().contains("a"));
        Assert.assertEquals((long)-1L, (long)metadataCollection.getLifespan());
        Assert.assertEquals((long)0L, (long)metadataCollection.getVersion());
    }

    @Test
    public void testRemoveKey() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        multimapCache.put((Object)"k", (Object)"a").join();
        Collection kValues = (Collection)multimapCache.get((Object)"k").join();
        Assert.assertEquals((long)1L, (long)kValues.size());
        Assert.assertTrue((boolean)kValues.contains("a"));
        Assert.assertTrue((boolean)((Boolean)multimapCache.remove((Object)"k").join()));
        Assert.assertEquals((long)0L, (long)((Collection)multimapCache.get((Object)"k").join()).size());
        Assert.assertFalse((boolean)((Boolean)multimapCache.remove((Object)"k").join()));
    }

    @Test
    public void testRemoveKeyValue() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        multimapCache.put((Object)"k", (Object)"a").join();
        multimapCache.put((Object)"k", (Object)"b").join();
        multimapCache.put((Object)"k", (Object)"c").join();
        Collection kValues = (Collection)multimapCache.get((Object)"k").join();
        Assert.assertEquals((long)3L, (long)kValues.size());
        Assert.assertTrue((boolean)((Boolean)multimapCache.remove((Object)"k", (Object)"a").join()));
        Assert.assertEquals((long)2L, (long)((Collection)multimapCache.get((Object)"k").join()).size());
    }

    @Test
    public void testSize() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        Assert.assertEquals((Object)0L, multimapCache.size().join());
        multimapCache.put((Object)"k", (Object)"a").join();
        Assert.assertEquals((Object)1L, multimapCache.size().join());
        multimapCache.put((Object)"k", (Object)"b").join();
        Assert.assertEquals((Object)2L, multimapCache.size().join());
    }

    @Test
    public void testContainsEntry() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        multimapCache.put((Object)"k", (Object)"a").join();
        Assert.assertTrue((boolean)((Boolean)multimapCache.containsEntry((Object)"k", (Object)"a").join()));
        Assert.assertFalse((boolean)((Boolean)multimapCache.containsEntry((Object)"k", (Object)"b").join()));
    }

    @Test
    public void testContainsKey() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        multimapCache.put((Object)"k", (Object)"a").join();
        Assert.assertTrue((boolean)((Boolean)multimapCache.containsKey((Object)"k").join()));
        Assert.assertFalse((boolean)((Boolean)multimapCache.containsKey((Object)"l").join()));
    }

    @Test
    public void testContainsValue() {
        RemoteMultimapCache multimapCache = this.multimapCache();
        multimapCache.put((Object)"k", (Object)"a").join();
        Assert.assertTrue((boolean)((Boolean)multimapCache.containsValue((Object)"a").join()));
        Assert.assertFalse((boolean)((Boolean)multimapCache.containsValue((Object)"b").join()));
    }

    private <K, V> RemoteMultimapCache<K, V> multimapCache() {
        RemoteCache cache = this.SERVER_TEST.hotrod().create();
        MultimapCacheManager multimapCacheManager = RemoteMultimapCacheManagerFactory.from((RemoteCacheManager)cache.getRemoteCacheManager());
        return multimapCacheManager.get(cache.getName());
    }
}

