/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.rest.IpFilterRule;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ProtocolManagementIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/MultiEndpointClusteredServerTest.xml").runMode(ServerRunMode.EMBEDDED)).numServers(2)).property("infinispan.bind.address", "0.0.0.0")).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testIpFilter() throws IOException {
        NetworkAddress loopback = NetworkAddress.loopback((String)"loopback");
        RestClientConfigurationBuilder loopbackBuilder = new RestClientConfigurationBuilder();
        loopbackBuilder.addServer().host(loopback.getAddress().getHostAddress()).port(11222);
        RestClient loopbackClient = this.SERVER_TEST.rest().withClientConfiguration(loopbackBuilder).get();
        Common.assertStatus(200, loopbackClient.server().connectorNames());
        NetworkAddress siteLocal = NetworkAddress.match((String)"sitelocal", iF -> !iF.getName().startsWith("docker"), InetAddress::isSiteLocalAddress);
        RestClientConfigurationBuilder siteLocalBuilder0 = new RestClientConfigurationBuilder();
        siteLocalBuilder0.addServer().host(siteLocal.getAddress().getHostAddress()).port(11222);
        RestClient siteLocalClient0 = this.SERVER_TEST.rest().withClientConfiguration(siteLocalBuilder0).get();
        Common.assertStatus(200, siteLocalClient0.server().connectorNames());
        RestClientConfigurationBuilder siteLocalBuilder1 = new RestClientConfigurationBuilder();
        siteLocalBuilder1.addServer().host(siteLocal.getAddress().getHostAddress()).port(11322);
        RestClient siteLocalClient1 = this.SERVER_TEST.rest().withClientConfiguration(siteLocalBuilder1).get();
        Common.assertStatus(200, siteLocalClient1.server().connectorNames());
        ArrayList<IpFilterRule> rules = new ArrayList<IpFilterRule>();
        rules.add(new IpFilterRule(IpFilterRule.RuleType.REJECT, siteLocal.cidr()));
        Common.assertStatus(204, loopbackClient.server().connectorIpFilterSet("endpoint-default", rules));
        Exceptions.expectException(RuntimeException.class, ExecutionException.class, SocketException.class, () -> Common.sync(siteLocalClient0.server().connectorNames()));
        Exceptions.expectException(RuntimeException.class, ExecutionException.class, SocketException.class, () -> Common.sync(siteLocalClient1.server().connectorNames()));
        Common.assertStatus(204, loopbackClient.server().connectorIpFiltersClear("endpoint-default"));
        Common.assertStatus(200, siteLocalClient0.server().connectorNames());
        Common.assertStatus(200, siteLocalClient1.server().connectorNames());
        Common.assertStatus(409, siteLocalClient0.server().connectorIpFilterSet("endpoint-default", rules));
        Common.assertStatus(204, loopbackClient.server().connectorIpFilterSet("HotRod-hotrod", rules));
        ConfigurationBuilder hotRodSiteLocalBuilder = new ConfigurationBuilder();
        hotRodSiteLocalBuilder.addServer().host(siteLocal.getAddress().getHostAddress()).port(11222).clientIntelligence(ClientIntelligence.BASIC);
        RemoteCacheManager siteLocalRemoteCacheManager = this.SERVER_TEST.hotrod().withClientConfiguration(hotRodSiteLocalBuilder).createRemoteCacheManager();
        Exceptions.expectException(TransportException.class, () -> ((RemoteCacheManager)siteLocalRemoteCacheManager).getCacheNames());
        Common.assertStatus(204, siteLocalClient0.server().connectorIpFiltersClear("HotRod-hotrod"));
        Assert.assertNotNull((Object)siteLocalRemoteCacheManager.getCacheNames());
    }

    @Test
    public void testConnectorStartStop() throws IOException {
        NetworkAddress loopback = NetworkAddress.loopback((String)"loopback");
        RestClientConfigurationBuilder defaultBuilder = new RestClientConfigurationBuilder();
        defaultBuilder.addServer().host(loopback.getAddress().getHostAddress()).port(11222);
        RestClient defaultClient = this.SERVER_TEST.rest().withClientConfiguration(defaultBuilder).get();
        Common.assertStatus(200, defaultClient.caches());
        RestClientConfigurationBuilder alternateBuilder = new RestClientConfigurationBuilder();
        alternateBuilder.addServer().host(loopback.getAddress().getHostAddress()).port(11223);
        RestClient alternateClient = this.SERVER_TEST.rest().withClientConfiguration(alternateBuilder).get();
        Common.assertStatus(200, alternateClient.caches());
        Common.assertStatus(204, defaultClient.server().connectorStop("endpoint-alternate-1"));
        Exceptions.expectException(RuntimeException.class, ExecutionException.class, SocketException.class, () -> Common.sync(alternateClient.caches()));
        Common.assertStatus(204, defaultClient.server().connectorStart("endpoint-alternate-1"));
        Common.assertStatus(200, alternateClient.caches());
        Common.assertStatus(409, defaultClient.server().connectorStop("endpoint-default"));
    }
}

