/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.ConvertUtil;
import org.infinispan.rest.resources.AbstractRestResourceTest;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RestOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    private final Protocol protocol;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(Common.HTTP_PROTOCOLS.size());
        for (Protocol protocol : Common.HTTP_PROTOCOLS) {
            params.add(new Object[]{protocol});
        }
        return params;
    }

    public RestOperations(Protocol protocol) {
        this.protocol = protocol;
    }

    @Test
    public void testRestOperations() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.protocol(this.protocol);
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        RestResponse response = (RestResponse)Common.sync(cache.put("k1", "v1"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
        response = (RestResponse)Common.sync(cache.get("k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
        Assert.assertEquals((Object)"v1", (Object)response.getBody());
        response = (RestResponse)Common.sync(cache.remove("k1"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
        response = (RestResponse)Common.sync(cache.get("k1"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
    }

    @Test
    public void testPutWithTimeToLive() throws InterruptedException {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.protocol(this.protocol);
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        Common.sync(cache.post("k1", "v1", 1L, 1L));
        Assert.assertEquals((long)HttpResponseStatus.OK.code(), (long)((RestResponse)Common.sync(cache.get("k1"))).getStatus());
        Thread.sleep(2000L);
        Assert.assertEquals((long)HttpResponseStatus.NOT_FOUND.code(), (long)((RestResponse)Common.sync(cache.get("k1"))).getStatus());
    }

    @Test
    public void taskFilter() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.protocol(this.protocol);
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
        RestResponse tasks = (RestResponse)Common.sync(client.tasks().list(RestTaskClient.ResultType.USER));
        List taskListNode = Json.read((String)tasks.getBody()).asJsonList();
        taskListNode.forEach(n -> Assert.assertFalse((boolean)n.at("name").asString().startsWith("@@")));
    }

    @Test
    public void testCounter() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.protocol(this.protocol);
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
        CounterConfiguration configuration = CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).concurrencyLevel(1).build();
        AbstractCounterConfiguration config = ConvertUtil.configToParsedConfig((String)"test-counter", (CounterConfiguration)configuration);
        String configJson = AbstractRestResourceTest.counterConfigToJson((AbstractCounterConfiguration)config);
        RestCounterClient counter = client.counter("test");
        RestResponse rsp = (RestResponse)Common.sync(counter.create(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)configJson)));
        Assert.assertEquals((long)HttpResponseStatus.OK.code(), (long)rsp.getStatus());
        rsp = (RestResponse)Common.sync(counter.get());
        Assert.assertEquals((Object)"5", (Object)rsp.getBody());
    }
}

