/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import org.aesh.command.shell.Shell;
import org.aesh.terminal.Connection;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.impl.AeshDelegatingShell;
import org.infinispan.client.rest.RestClient;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.server.functional.AbstractMultiClusterIT;
import org.infinispan.server.functional.RollingUpgradeDynamicStoreIT;
import org.infinispan.server.test.core.AeshTestConnection;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class RollingUpgradeDynamicStoreCliIT
extends RollingUpgradeDynamicStoreIT {
    private static File workingDir;
    private static Properties properties;
    private static Path dest;
    private static final String REMOTE_STORE_CFG_FILE = "remote-store.json";

    @BeforeClass
    public static void setup() {
        workingDir = new File(CommonsTestingUtil.tmpDirectory(RollingUpgradeDynamicStoreCliIT.class));
        Util.recursiveFileRemove((File)workingDir);
        workingDir.mkdirs();
        properties = new Properties(System.getProperties());
        properties.put("cli.dir", workingDir.getAbsolutePath());
        dest = workingDir.toPath().resolve(REMOTE_STORE_CFG_FILE);
        try (InputStream is = RollingUpgradeDynamicStoreCliIT.class.getResourceAsStream("/cli/remote-store.json");){
            Files.copy(is, dest, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @AfterClass
    public static void teardown() {
        Util.recursiveFileRemove((File)workingDir);
    }

    @Override
    protected void connectTargetCluster() {
        try {
            String cfg = new String(Files.readAllBytes(dest), StandardCharsets.UTF_8);
            cfg = cfg.replace("127.0.0.1", this.source.driver.getServerAddress(0).getHostAddress());
            cfg = cfg.replace("11222", Integer.toString(this.source.getSinglePort(0)));
            Files.write(dest, cfg.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (AeshTestConnection terminal = new AeshTestConnection();){
            CLI.main((Shell)new AeshDelegatingShell((Connection)terminal), (String[])new String[0], (Properties)properties);
            this.connectToCluster(terminal, this.target);
            terminal.assertContains("//containers/default]>");
            terminal.clear();
            terminal.readln("migrate cluster connect --file=" + dest + " --cache=" + "rolling");
            terminal.clear();
            terminal.readln("migrate cluster source-connection --cache=rolling");
            terminal.assertContains("remote-store");
        }
    }

    @Override
    protected void assertSourceConnected() {
        try (AeshTestConnection terminal = new AeshTestConnection();){
            CLI.main((Shell)new AeshDelegatingShell((Connection)terminal), (String[])new String[0], (Properties)properties);
            this.connectToCluster(terminal, this.target);
            terminal.assertContains("//containers/default]>");
            terminal.clear();
            terminal.readln("migrate cluster source-connection --cache=rolling");
            terminal.assertContains("remote-store");
        }
    }

    @Override
    protected void assertSourceDisconnected() {
        try (AeshTestConnection terminal = new AeshTestConnection();){
            CLI.main((Shell)new AeshDelegatingShell((Connection)terminal), (String[])new String[0], (Properties)properties);
            this.connectToCluster(terminal, this.target);
            terminal.assertContains("//containers/default]>");
            terminal.clear();
            terminal.readln("migrate cluster source-connection --cache=rolling");
            terminal.assertContains("Not Found");
        }
    }

    @Override
    protected void doRollingUpgrade(RestClient client) {
        try (AeshTestConnection terminal = new AeshTestConnection();){
            CLI.main((Shell)new AeshDelegatingShell((Connection)terminal), (String[])new String[0], (Properties)properties);
            this.connectToCluster(terminal, this.target);
            terminal.assertContains("//containers/default]>");
            terminal.clear();
            terminal.readln("migrate cluster synchronize --cache=rolling");
        }
    }

    @Override
    protected void disconnectSource(RestClient client) {
        try (AeshTestConnection terminal = new AeshTestConnection();){
            CLI.main((Shell)new AeshDelegatingShell((Connection)terminal), (String[])new String[0], (Properties)properties);
            this.connectToCluster(terminal, this.target);
            terminal.assertContains("//containers/default]>");
            terminal.clear();
            terminal.readln("migrate cluster disconnect --cache=rolling");
        }
    }

    private void connectToCluster(AeshTestConnection terminal, AbstractMultiClusterIT.Cluster cluster) {
        terminal.readln("connect " + cluster.driver.getServerAddress(0).getHostAddress() + ":" + cluster.getSinglePort(0));
    }
}

