/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.persistence.JdbcConfigurationUtil;
import org.infinispan.server.persistence.PersistenceIT;
import org.infinispan.server.persistence.TableManipulation;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.category.Persistence;
import org.infinispan.server.test.core.persistence.Database;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={Persistence.class})
@RunWith(value=Parameterized.class)
public class AsyncJdbcStringBasedCacheStore {
    @ClassRule
    public static InfinispanServerRule SERVERS = PersistenceIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final Database database;

    public AsyncJdbcStringBasedCacheStore(String databaseType) {
        this.database = PersistenceIT.DATABASE_LISTENER.getDatabase(databaseType);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        String[] databaseTypes = PersistenceIT.DATABASE_LISTENER.getDatabaseTypes();
        ArrayList<Object[]> params = new ArrayList<Object[]>(databaseTypes.length);
        for (String databaseType : databaseTypes) {
            params.add(new Object[]{databaseType});
        }
        return params;
    }

    @Test
    public void testPutRemove() throws Exception {
        int numEntries = 10;
        String keyPrefix = "testPutRemove-k-";
        String valuePrefix = "testPutRemove-k-";
        JdbcConfigurationUtil jdbcUtil = new JdbcConfigurationUtil(CacheMode.REPL_SYNC, this.database, false, true).setLockingConfigurations();
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(jdbcUtil.getConfigurationBuilder())).create();
        try (TableManipulation table = new TableManipulation(cache.getName(), jdbcUtil.getPersistenceConfiguration(), jdbcUtil.getConfigurationBuilder());){
            int i;
            for (i = 0; i < numEntries; ++i) {
                cache.putAsync((Object)(keyPrefix + i), (Object)(valuePrefix + i)).toCompletableFuture().get();
            }
            this.assertCountRow(table.countAllRows(), numEntries);
            for (i = 0; i < numEntries; ++i) {
                String key = keyPrefix + i;
                String keyFromDatabase = table.getValueByKey(key);
                Assert.assertNotNull((String)("Key " + key + " was not found in DB"), (Object)keyFromDatabase);
            }
            for (i = 0; i < numEntries; ++i) {
                cache.removeAsync((Object)(keyPrefix + i)).toCompletableFuture().get();
            }
            this.assertCountRow(table.countAllRows(), 0);
        }
    }

    public void assertCountRow(int result, int numberExpected) {
        Assert.assertEquals((long)numberExpected, (long)result);
    }
}

