/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.persistence.AsyncJdbcStringBasedCacheStore;
import org.infinispan.server.persistence.JdbcStringBasedCacheStorePassivation;
import org.infinispan.server.persistence.ManagedConnectionOperations;
import org.infinispan.server.persistence.PooledConnectionOperations;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.core.persistence.DatabaseServerListener;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={PooledConnectionOperations.class, ManagedConnectionOperations.class, JdbcStringBasedCacheStorePassivation.class, AsyncJdbcStringBasedCacheStore.class})
public class PersistenceIT {
    private static final String DATABASE_LIBS = System.getProperty("org.infinispan.test.database.jdbc.drivers");
    private static final String EXTERNAL_JDBC_DRIVER = System.getProperty("org.infinispan.test.database.jdbc.drivers.external");
    private static final String JDBC_DRIVER_FROM_FILE = System.getProperty("org.infinispan.test.database.jdbc.drivers.file", "src/test/resources/database/jdbc-drivers.txt");
    public static final DatabaseServerListener DATABASE_LISTENER = new DatabaseServerListener(new String[]{"h2", "mysql", "postgres"});
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)System.getProperty(PersistenceIT.class.getName(), "configuration/PersistenceTest.xml")).numServers(1)).runMode(ServerRunMode.CONTAINER)).mavenArtifacts(PersistenceIT.getJdbcDrivers())).artifacts(PersistenceIT.getJavaArchive())).addListener((InfinispanServerListener)DATABASE_LISTENER)).build();

    private static String[] getJdbcDrivers() {
        Map jdbcDrivers = (Map)Exceptions.unchecked(() -> Files.lines(Paths.get(JDBC_DRIVER_FROM_FILE, new String[0])).collect(Collectors.toMap(PersistenceIT::getArtifactId, Function.identity())));
        if (DATABASE_LIBS != null) {
            Arrays.stream(DATABASE_LIBS.split(",")).forEach(it -> jdbcDrivers.put(PersistenceIT.getArtifactId(it), it));
        }
        return jdbcDrivers.values().toArray(new String[0]);
    }

    private static String getArtifactId(String gav) {
        return gav.split(":")[1];
    }

    private static JavaArchive[] getJavaArchive() {
        ArrayList externalJdbcDriver = new ArrayList();
        if (EXTERNAL_JDBC_DRIVER != null) {
            Arrays.stream(EXTERNAL_JDBC_DRIVER.split(",")).map(File::new).forEach(it -> externalJdbcDriver.add((JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)it)));
        }
        return externalJdbcDriver.toArray(new JavaArchive[0]);
    }
}

