/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resilience;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.test.Eventually;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.core.category.Resilience;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Resilience.class})
public class ResilienceIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").runMode(ServerRunMode.CONTAINER)).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testUnresponsiveNode() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.socketTimeout(1000).connectionTimeout(1000).maxRetries(10).connectionPool().maxActive(1);
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.REPL_SYNC)).create();
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
        SERVERS.getServerDriver().pause(0);
        Eventually.eventually((String)"Cluster should have 1 node", () -> {
            cache.get((Object)"k1");
            return cache.getCacheTopologyInfo().getSegmentsPerServer().size() == 1;
        }, (long)30L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        SERVERS.getServerDriver().resume(0);
        Eventually.eventually((String)"Cluster should have 2 nodes", () -> {
            cache.get((Object)"k1");
            return cache.getCacheTopologyInfo().getSegmentsPerServer().size() == 2;
        }, (long)30L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }
}

