/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractAuthenticationKeyCloak {
    public static final String INFINISPAN_REALM = "infinispan";
    public static final String INFINISPAN_CLIENT_ID = "infinispan-client";
    public static final String INFINISPAN_CLIENT_SECRET = "8a43581d-62d7-47dc-9aa4-cd3af24b6083";

    protected abstract InfinispanServerTestMethodRule getServerTest();

    @Test
    public void testHotRodReadWrite() {
        String token = this.getToken();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().saslMechanism("OAUTHBEARER").serverName(INFINISPAN_REALM).realm("default").token(token);
        RemoteCache cache = ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
    }

    @Test
    public void testRestReadWrite() {
        String token = this.getToken();
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.security().authentication().mechanism("BEARER_TOKEN").username(token);
        RestClient client = this.getServerTest().rest().withClientConfiguration(builder).create();
        RestResponse response = (RestResponse)Common.sync(client.cache(this.getServerTest().getMethodName()).post("k1", "v1"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.cache(this.getServerTest().getMethodName()).get("k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"v1", (Object)response.getBody());
    }

    protected abstract String getToken();
}

