/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.security.VoidCallbackHandler;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.LdapServerListener;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class AuthenticationKerberosIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationKerberosTest.xml").numServers(1)).property("java.security.krb5.conf", "${infinispan.server.config.path}/krb5.conf")).addListener((InfinispanServerListener)new LdapServerListener(new String[]{"ldif/infinispan-dn.ldif", "ldif/infinispan-kerberos.ldif"}, true))).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final String protocol;
    private final String mechanism;
    private static String oldKrb5Conf;

    @Parameterized.Parameters(name="{1}({0})")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Object[] mech : Common.SASL_KERBEROS_MECHS) {
            params.add(new Object[]{"Hot Rod", mech[0]});
        }
        for (Protocol protocol : Common.HTTP_PROTOCOLS) {
            for (Object[] mech : Common.HTTP_KERBEROS_MECHS) {
                params.add(new Object[]{protocol.name(), mech[0]});
            }
        }
        return params;
    }

    public AuthenticationKerberosIT(String protocol, String mechanism) {
        this.protocol = protocol;
        this.mechanism = mechanism;
    }

    @BeforeClass
    public static void setKrb5Conf() {
        oldKrb5Conf = System.setProperty("java.security.krb5.conf", Paths.get("src/test/resources/configuration/krb5.conf", new String[0]).toString());
    }

    @AfterClass
    public static void restoreKrb5Conf() {
        if (oldKrb5Conf != null) {
            System.setProperty("java.security.krb5.conf", oldKrb5Conf);
        }
    }

    @Test
    public void testProtocol() {
        if ("Hot Rod".equals(this.protocol)) {
            this.testHotRod();
        } else {
            this.testRest(Protocol.valueOf((String)this.protocol));
        }
    }

    public void testHotRod() {
        block3: {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (!this.mechanism.isEmpty()) {
                builder.security().authentication().saslMechanism(this.mechanism).serverName("datagrid").callbackHandler((CallbackHandler)new VoidCallbackHandler()).clientSubject(Common.createSubject("admin", "INFINISPAN.ORG", "strongPassword".toCharArray()));
            }
            try {
                RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
                cache.put((Object)"k1", (Object)"v1");
                Assert.assertEquals((long)1L, (long)cache.size());
                Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
            }
            catch (HotRodClientException e) {
                if (this.mechanism.isEmpty()) break block3;
                throw e;
            }
        }
    }

    public void testRest(Protocol protocol) {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        if (!this.mechanism.isEmpty()) {
            builder.protocol(protocol).security().authentication().mechanism(this.mechanism).clientSubject(Common.createSubject("admin", "INFINISPAN.ORG", "strongPassword".toCharArray()));
        }
        if (this.mechanism.isEmpty()) {
            Exceptions.expectException(SecurityException.class, () -> this.SERVER_TEST.rest().withClientConfiguration(builder).create());
        } else {
            RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
            RestResponse response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).post("k1", "v1"));
            Assert.assertEquals((long)204L, (long)response.getStatus());
            Assert.assertEquals((Object)protocol, (Object)response.getProtocol());
            response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).get("k1"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)protocol, (Object)response.getProtocol());
            Assert.assertEquals((Object)"v1", (Object)response.getBody());
        }
    }
}

