/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.infinispan.server.security.AbstractAuthenticationKeyCloak;
import org.infinispan.server.test.core.EmbeddedInfinispanServerDriver;
import org.infinispan.server.test.core.KeyCloakServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.ClassRule;
import org.junit.Rule;

public class AuthenticationKeyCloakSSLIT
extends AbstractAuthenticationKeyCloak {
    @ClassRule
    public static final InfinispanServerRule SERVERS = InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationKeyCloakSSLTest.xml").build();
    @ClassRule
    public static KeyCloakServerRule KEYCLOAK = new KeyCloakServerRule(System.getProperty("org.infinispan.test.keycloakRealm", "keycloak/infinispan-keycloak-realm.json")).addBeforeListener(k -> {
        Path serverConfPath = SERVERS.getServerDriver().getConfDir().toPath();
        Path keyCloakPath = k.getKeycloakDirectory().toPath();
        try {
            Files.copy(serverConfPath.resolve("ca.crt"), keyCloakPath.resolve("tls.crt"), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(serverConfPath.resolve("ca.key"), keyCloakPath.resolve("tls.key"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Override
    protected InfinispanServerTestMethodRule getServerTest() {
        return this.SERVER_TEST;
    }

    @Override
    protected String getToken() {
        EmbeddedInfinispanServerDriver driver = (EmbeddedInfinispanServerDriver)SERVERS.getServerDriver();
        return KEYCLOAK.getAccessTokenForCredentials("infinispan", "infinispan-client", "8a43581d-62d7-47dc-9aa4-cd3af24b6083", "admin", "adminPassword", SERVERS.getServerDriver().getCertificateFile("ca").toPath(), "secret");
    }
}

