/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.LdapServerListener;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class AuthenticationMultiRealmIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationMultiRealm.xml").addListener((InfinispanServerListener)new LdapServerListener())).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testLDAP() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        SERVERS.getServerDriver().applyTrustStore(builder, "ca");
        builder.security().authentication().saslMechanism("SCRAM-SHA-256").serverName("infinispan").realm("default").username(TestUser.ADMIN.getUser()).password(TestUser.ADMIN.getPassword());
        this.performOperations(builder);
    }

    @Test
    public void testProps() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        SERVERS.getServerDriver().applyTrustStore(builder, "ca");
        builder.security().authentication().saslMechanism("SCRAM-SHA-256").serverName("infinispan").realm("default").username("all_user").password("all");
        this.performOperations(builder);
    }

    @Test
    public void testCert() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.maxRetries(1).connectionPool().maxActive(1);
        SERVERS.getServerDriver().applyTrustStore(builder, "ca");
        SERVERS.getServerDriver().applyKeyStore(builder, "admin");
        builder.security().authentication().saslMechanism("EXTERNAL").serverName("infinispan").realm("default");
        this.performOperations(builder);
    }

    @Test
    public void testUnknown() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        SERVERS.getServerDriver().applyTrustStore(builder, "ca");
        builder.security().authentication().saslMechanism("SCRAM-SHA-256").serverName("infinispan").realm("default").username("unknown").password("unknown");
        Exceptions.expectException((String)".*ELY05161.*", () -> this.performOperations(builder), (Class[])new Class[]{TransportException.class});
    }

    private void performOperations(ConfigurationBuilder builder) {
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
    }
}

