/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.ldap.AbstractLdapServer;
import org.infinispan.server.test.core.ldap.ApacheLdapServer;
import org.infinispan.server.test.core.ldap.RemoteLdapServer;

public class LdapServerListener
implements InfinispanServerListener {
    public static final String LDAP_SERVER = System.getProperty("org.infinispan.test.ldapServer", "apache");
    public static final String[] DEFAULT_LDIF = new String[]{"ldif/infinispan-dn.ldif", "ldif/infinispan.ldif"};
    private final String[] initLDIFs;
    private AbstractLdapServer ldapServer;
    private boolean withKdc;

    public LdapServerListener() {
        this(DEFAULT_LDIF, false);
    }

    public LdapServerListener(String[] initLDIFs, boolean withKdc) {
        this.initLDIFs = initLDIFs;
        this.withKdc = withKdc;
        if ("apache".equals(LDAP_SERVER)) {
            this.ldapServer = new ApacheLdapServer();
        } else if ("remote".equals(LDAP_SERVER)) {
            this.ldapServer = new RemoteLdapServer();
        } else {
            throw new IllegalStateException("Unsupported LDAP Server: " + LDAP_SERVER);
        }
    }

    public void before(InfinispanServerDriver driver) {
        Exceptions.unchecked(() -> {
            if (this.withKdc) {
                LdapServerListener.generateKeyTab(new File(driver.getConfDir(), "hotrod.keytab"), "hotrod/datagrid@INFINISPAN.ORG", "hotrodPassword");
                LdapServerListener.generateKeyTab(new File(driver.getConfDir(), "http.keytab"), "HTTP/localhost@INFINISPAN.ORG", "httpPassword");
            }
            this.ldapServer.start(driver.getCertificateFile("server").getAbsolutePath(), this.initLDIFs);
            if (this.withKdc) {
                this.ldapServer.startKdc();
            }
        });
    }

    public void after(InfinispanServerDriver driver) {
        try {
            this.ldapServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThreadLeakChecker.ignoreThreadsContaining((String)"pool-.*thread-");
        ThreadLeakChecker.ignoreThreadsContaining((String)"^Thread-\\d+$");
    }

    public static String generateKeyTab(File keyTabFile, String ... credentials) {
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        KerberosTime ktm = new KerberosTime();
        int i = 0;
        while (i < credentials.length) {
            String principal = credentials[i++];
            String password = credentials[i++];
            for (Map.Entry keyEntry : KerberosKeyFactory.getKerberosKeys((String)principal, (String)password).entrySet()) {
                EncryptionKey key = (EncryptionKey)keyEntry.getValue();
                entries.add(new KeytabEntry(principal, 1, ktm, (byte)key.getKeyVersion(), key));
            }
        }
        Keytab keyTab = Keytab.getInstance();
        keyTab.setEntries(entries);
        try {
            keyTab.write(keyTabFile);
            return keyTabFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create keytab: " + keyTabFile, e);
        }
    }
}

