/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resilience;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Eventually;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class GracefulShutdownRestartIT {
    @ClassRule
    public static final InfinispanServerRule SERVER = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").numServers(2)).runMode(ServerRunMode.CONTAINER)).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVER);

    @Test
    public void testGracefulShutdownRestart() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).persistence().addSingleFileStore().segmented(false);
        RemoteCache hotRod = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(builder)).create();
        for (int i = 0; i < 100; ++i) {
            hotRod.put((Object)String.format("k%03d", i), (Object)String.format("v%03d", i));
        }
        RestClientConfigurationBuilder restClientBuilder = new RestClientConfigurationBuilder().socketTimeout(3600000L).connectionTimeout(3600000L);
        RestClient rest = this.SERVER_TEST.rest().withClientConfiguration(restClientBuilder).get();
        Common.sync(rest.cluster().stop(), 5L, TimeUnit.MINUTES);
        ContainerInfinispanServerDriver serverDriver = (ContainerInfinispanServerDriver)SERVER.getServerDriver();
        Eventually.eventually((String)"Cluster did not shutdown within timeout", () -> !serverDriver.isRunning(0) && !serverDriver.isRunning(1), (long)serverDriver.getTimeout(), (long)1L, (TimeUnit)TimeUnit.SECONDS);
        serverDriver.restartCluster();
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)String.format("v%03d", i), (Object)hotRod.get((Object)String.format("k%03d", i)));
        }
    }
}

