/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.SecurityRealmServerListener;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class AuthenticationMultiEndpointIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationServerMultipleEndpoints.xml").addListener((InfinispanServerListener)new SecurityRealmServerListener("alternate"))).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final String mechanism;
    private final String protocol;
    private final String realm;
    private final String userPrefix;
    private final int port;
    private final boolean isAnonymous;
    private final boolean isAdmin;
    private final boolean isPlain;
    private final boolean isAlternateRealm;
    private final boolean useAuth;
    private final boolean isMechanismClearText;

    @Parameterized.Parameters(name="protocol={0}, mech={1}, realm={2}, userPrefix={3}, port={4}, anon={5}, admin={6}, plain={7}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String realm : Arrays.asList("default", "alternate")) {
            String userPrefix = "alternate".equals(realm) ? "alternate_" : "";
            for (int p = 11222; p < 11227; ++p) {
                boolean isAlternateRealmHTTP;
                boolean isAlternateRealmHotRod;
                boolean isPlain;
                boolean isAdmin;
                boolean isAnonymous;
                Integer port = p;
                switch (p) {
                    case 11222: {
                        isAnonymous = false;
                        isAdmin = true;
                        isPlain = true;
                        isAlternateRealmHotRod = false;
                        isAlternateRealmHTTP = false;
                        break;
                    }
                    case 11223: {
                        isAnonymous = true;
                        isAdmin = false;
                        isPlain = false;
                        isAlternateRealmHotRod = false;
                        isAlternateRealmHTTP = false;
                        break;
                    }
                    case 11224: {
                        isAnonymous = false;
                        isAdmin = false;
                        isPlain = true;
                        isAlternateRealmHotRod = true;
                        isAlternateRealmHTTP = true;
                        break;
                    }
                    case 11225: {
                        isAnonymous = false;
                        isAdmin = true;
                        isPlain = false;
                        isAlternateRealmHotRod = true;
                        isAlternateRealmHTTP = false;
                        break;
                    }
                    case 11226: {
                        isAnonymous = false;
                        isAdmin = true;
                        isPlain = false;
                        isAlternateRealmHotRod = false;
                        isAlternateRealmHTTP = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                Common.SASL_MECHS.stream().map(m -> m[0]).forEach(m -> params.add(new Object[]{"Hot Rod", m, realm, userPrefix, port, isAnonymous, isAdmin, isPlain, isAlternateRealmHotRod}));
                Common.HTTP_MECHS.stream().map(m -> m[0]).forEach(m -> params.add(new Object[]{Protocol.HTTP_11.name(), m, realm, userPrefix, port, isAnonymous, isAdmin, isPlain, isAlternateRealmHTTP}));
            }
        }
        return params;
    }

    public AuthenticationMultiEndpointIT(String protocol, String mechanism, String realm, String userPrefix, int port, boolean isAnonymous, boolean isAdmin, boolean isPlain, boolean isAlternateRealm) {
        this.protocol = protocol;
        this.mechanism = mechanism;
        this.realm = realm;
        this.userPrefix = userPrefix;
        this.port = port;
        this.isAdmin = isAdmin;
        this.isAnonymous = isAnonymous;
        this.isPlain = isPlain;
        this.isAlternateRealm = isAlternateRealm;
        this.useAuth = !mechanism.isEmpty();
        this.isMechanismClearText = "PLAIN".equals(mechanism) || "BASIC".equals(mechanism);
    }

    @Test
    public void testProtocol() {
        switch (this.protocol) {
            case "Hot Rod": {
                this.testHotRod();
                break;
            }
            default: {
                this.testRest();
            }
        }
    }

    private void testHotRod() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (this.useAuth) {
            builder.security().authentication().saslMechanism(this.mechanism).realm(this.realm).username(this.userPrefix + "all_user").password("all");
        }
        try {
            RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withPort(this.port).withCacheMode(CacheMode.DIST_SYNC)).create();
            this.validateSuccess();
            cache.put((Object)"k1", (Object)"v1");
            Assert.assertEquals((long)1L, (long)cache.size());
            Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
        }
        catch (HotRodClientException e) {
            this.validateException((RuntimeException)((Object)e));
        }
    }

    private void testRest() {
        Protocol proto = Protocol.valueOf((String)this.protocol);
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder().followRedirects(false);
        if (this.useAuth) {
            builder.protocol(proto).security().authentication().mechanism(this.mechanism).realm(this.realm).username(this.userPrefix + "all_user").password("all");
        }
        try {
            RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).withPort(this.port).create();
            this.validateSuccess();
            RestResponse response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).post("k1", "v1"));
            Assert.assertEquals((long)204L, (long)response.getStatus());
            Assert.assertEquals((Object)proto, (Object)response.getProtocol());
            response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).get("k1"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)proto, (Object)response.getProtocol());
            Assert.assertEquals((Object)"v1", (Object)response.getBody());
            response = (RestResponse)Common.sync(client.raw().get("/"));
            Assert.assertEquals((long)(this.isAdmin ? 307L : 404L), (long)response.getStatus());
            response = (RestResponse)Common.sync(client.server().info());
            Assert.assertEquals((long)(this.isAdmin ? 200L : 404L), (long)response.getStatus());
        }
        catch (SecurityException e) {
            this.validateException(e);
        }
    }

    private void validateSuccess() {
        if (this.isAnonymous && this.useAuth) {
            throw new IllegalStateException("Authenticated client should not be allowed to connect to anonymous server");
        }
        if (!this.isAnonymous && !this.useAuth) {
            throw new IllegalStateException("Unauthenticated client should not be allowed to connect to authenticated server");
        }
    }

    private void validateException(RuntimeException e) {
        if (this.useAuth && this.isAnonymous) {
            return;
        }
        if (!this.useAuth && !this.isAnonymous) {
            return;
        }
        if (this.isAlternateRealm && "default".equals(this.realm)) {
            return;
        }
        if (!this.isAlternateRealm && !"default".equals(this.realm)) {
            return;
        }
        if (this.isPlain && !this.isMechanismClearText) {
            return;
        }
        if (!this.isPlain && this.isMechanismClearText) {
            return;
        }
        throw e;
    }
}

