/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.rest.helper.RestResponses;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class IgnoreCaches {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private static final String CACHE_MANAGER = "default";

    @Test
    public void testIgnoreCaches() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
        String testCache = this.SERVER_TEST.getMethodName();
        Assert.assertTrue((boolean)this.getIgnoredCaches(client, CACHE_MANAGER).isEmpty());
        this.assertCacheResponse(client, testCache, 404);
        this.assertCacheResponse(client, "___protobuf_metadata", 404);
        this.ignoreCache(client, testCache);
        Assert.assertEquals(Collections.singleton(testCache), this.getIgnoredCaches(client, CACHE_MANAGER));
        this.assertCacheResponse(client, testCache, 503);
        this.assertCacheResponse(client, "___protobuf_metadata", 404);
        this.ignoreCache(client, "___protobuf_metadata");
        Assert.assertEquals(this.asSet(testCache, "___protobuf_metadata"), this.getIgnoredCaches(client, CACHE_MANAGER));
        this.assertCacheResponse(client, testCache, 503);
        this.assertCacheResponse(client, "___protobuf_metadata", 503);
        this.unIgnoreCache(client, testCache);
        Assert.assertEquals(Collections.singleton("___protobuf_metadata"), this.getIgnoredCaches(client, CACHE_MANAGER));
        this.assertCacheResponse(client, testCache, 404);
        this.assertCacheResponse(client, "___protobuf_metadata", 503);
        this.unIgnoreCache(client, "___protobuf_metadata");
        Assert.assertTrue((boolean)this.getIgnoredCaches(client, CACHE_MANAGER).isEmpty());
        this.assertCacheResponse(client, testCache, 404);
        this.assertCacheResponse(client, "___protobuf_metadata", 404);
    }

    private Set<String> asSet(String ... elements) {
        return Arrays.stream(elements).collect(Collectors.toSet());
    }

    private void assertCacheResponse(RestClient client, String cacheName, int code) {
        RestResponses.assertStatus((int)code, (CompletionStage)client.cache(cacheName).get("whatever"));
    }

    private void unIgnoreCache(RestClient client, String cacheName) {
        RestResponses.assertStatus((int)204, (CompletionStage)client.server().unIgnoreCache(CACHE_MANAGER, cacheName));
    }

    private void ignoreCache(RestClient client, String cacheName) {
        RestResponses.assertStatus((int)204, (CompletionStage)client.server().ignoreCache(CACHE_MANAGER, cacheName));
    }

    private Set<String> getIgnoredCaches(RestClient client, String cacheManagerName) {
        Json body = RestResponses.jsonResponseBody((CompletionStage)client.server().listIgnoredCaches(cacheManagerName));
        return body.asJsonList().stream().map(Json::asString).collect(Collectors.toSet());
    }
}

