/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.server.test.core.persistence.Database;
import org.infinispan.util.concurrent.IsolationLevel;

public class JdbcConfigurationUtil {
    private PooledConnectionFactoryConfigurationBuilder persistenceConfiguration;
    private ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
    private CacheMode cacheMode;

    public JdbcConfigurationUtil(CacheMode cacheMode, Database database, boolean passivation, boolean preload) {
        this.cacheMode = cacheMode;
        this.createPersistenceConfiguration(database, passivation, preload);
    }

    private JdbcConfigurationUtil createPersistenceConfiguration(Database database, boolean passivation, boolean preload) {
        this.persistenceConfiguration = ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)this.configurationBuilder.clustering().cacheMode(this.cacheMode).hash().numOwners(1).persistence().passivation(passivation).addStore(JdbcStringBasedStoreConfigurationBuilder.class)).shared(false)).preload(preload)).fetchPersistentState(true)).table().dropOnExit(false)).createOnStart(true)).tableNamePrefix("tbl")).idColumnName("id")).idColumnType(database.getIdColumType())).dataColumnName("data")).dataColumnType(database.getDataColumnType())).timestampColumnName("ts")).timestampColumnType(database.getTimeStampColumnType())).segmentColumnName("s")).segmentColumnType(database.getSegmentColumnType())).connectionPool().connectionUrl(database.jdbcUrl()).username(database.username()).password(database.password()).driverClass(database.driverClassName());
        return this;
    }

    public JdbcConfigurationUtil setLockingConfigurations() {
        this.configurationBuilder.locking().isolationLevel(IsolationLevel.READ_COMMITTED).lockAcquisitionTimeout(20000L).concurrencyLevel(500).useLockStriping(false);
        return this;
    }

    public JdbcConfigurationUtil setEvition() {
        this.configurationBuilder.memory().maxCount(2L);
        return this;
    }

    public PooledConnectionFactoryConfigurationBuilder getPersistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    public ConfigurationBuilder getConfigurationBuilder() {
        return this.configurationBuilder;
    }
}

