/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.ldap;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.infinispan.server.test.core.ldap.AbstractLdapServer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testcontainers.shaded.com.google.common.io.Files;

public class RemoteLdapServer
extends AbstractLdapServer {
    private static final Log log = LogFactory.getLog(RemoteLdapServer.class);

    @Override
    public void start(String keystoreFile, String[] initLDIFs) throws Exception {
        URI ldapUri = new URI(System.getProperty("org.infinispan.test.ldap.url"));
        LdapNetworkConnection connection = new LdapNetworkConnection(ldapUri.getHost(), ldapUri.getPort());
        connection.setTimeOut(60L);
        connection.bind(System.getProperty("org.infinispan.test.ldap.host.user"), System.getProperty("org.infinispan.test.ldap.host.password"));
        for (String initLDIF : initLDIFs) {
            if (initLDIF.contains("-dn.ldif")) continue;
            String fullPathFile = this.getClass().getClassLoader().getResource(initLDIF).getFile();
            String fileContent = Files.toString((File)new File(fullPathFile), (Charset)Charset.defaultCharset());
            String ldif = fileContent.replaceAll("ou=People,dc=infinispan,dc=org", System.getProperty("org.infinispan.test.ldap.search-dn")).replaceAll("ou=Roles,dc=infinispan,dc=org", System.getProperty("org.infinispan.test.ldap.search-dn"));
            LdifReader ldifReader = new LdifReader();
            List entries = ldifReader.parseLdif(ldif);
            for (LdifEntry ldifEntry : entries) {
                String originalDN = ldifEntry.getDn().toString();
                Entry entry = this.tranformEntry(ldifEntry.getEntry());
                if (entry == null) continue;
                try {
                    connection.add(entry);
                }
                catch (LdapEntryAlreadyExistsException e) {
                    log.debug((Object)originalDN, (Throwable)e);
                }
            }
        }
    }

    protected Entry tranformEntry(Entry entry) {
        return entry;
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public void startKdc() throws IOException, LdapInvalidDnException {
    }
}

