/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.cli;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aesh.command.shell.Shell;
import org.aesh.terminal.Connection;
import org.aesh.terminal.utils.Config;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.impl.AeshDelegatingShell;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.server.functional.XSiteIT;
import org.infinispan.server.test.core.AeshTestConnection;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;
import org.infinispan.server.test.junit4.InfinispanXSiteServerTestMethodRule;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class XSiteCliOperations {
    @ClassRule
    public static final InfinispanXSiteServerRule SERVERS = XSiteIT.SERVERS;
    @Rule
    public InfinispanXSiteServerTestMethodRule SERVER_TEST = new InfinispanXSiteServerTestMethodRule(SERVERS);
    private static File workingDir;
    private static Properties properties;

    @BeforeClass
    public static void setup() {
        workingDir = new File(CommonsTestingUtil.tmpDirectory(XSiteCliOperations.class));
        Util.recursiveFileRemove((File)workingDir);
        workingDir.mkdirs();
        properties = new Properties(System.getProperties());
        properties.put("cli.dir", workingDir.getAbsolutePath());
    }

    @AfterClass
    public static void teardown() {
        Util.recursiveFileRemove((File)workingDir);
    }

    @Test
    public void testSiteView() {
        this.doWithTerminal(terminal -> {
            this.connect((AeshTestConnection)terminal, "LON");
            terminal.readln("site name");
            terminal.assertContains("LON");
            terminal.clear();
            terminal.readln("site view");
            terminal.assertContains("LON");
            terminal.assertContains("NYC");
            terminal.clear();
            this.disconnect((AeshTestConnection)terminal);
            this.connect((AeshTestConnection)terminal, "NYC");
            terminal.readln("site name");
            terminal.assertContains("NYC");
            terminal.clear();
            terminal.readln("site view");
            terminal.assertContains("LON");
            terminal.assertContains("NYC");
            terminal.clear();
        });
    }

    @Test
    public void testStateTransferModeCli() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.clustering().sites().addBackup().site("NYC").strategy(BackupConfiguration.BackupStrategy.ASYNC).stateTransfer().mode(XSiteStateTransferMode.AUTO);
        this.SERVER_TEST.hotrod("LON").createRemoteCacheManager().administration().createCache("st-mode", (BasicConfiguration)builder.build());
        this.doWithTerminal(terminal -> {
            this.connect((AeshTestConnection)terminal, "LON");
            terminal.readln("site state-transfer-mode");
            terminal.assertContains("Usage: site state-transfer-mode [<options>]");
            terminal.clear();
            terminal.readln("site state-transfer-mode get");
            terminal.assertContains("Option: --site is required for this command.");
            terminal.clear();
            terminal.readln("site state-transfer-mode get --site=NYC");
            terminal.assertContains("Command invoked from the wrong context");
            terminal.clear();
            terminal.readln("cd caches/___script_cache");
            terminal.clear();
            terminal.readln("site state-transfer-mode get --site=NYC");
            terminal.assertContains("Not Found: Cache '___script_cache' does not have backup sites.");
            terminal.clear();
            terminal.readln("site state-transfer-mode get --cache=st-mode --site=NYC");
            terminal.assertContains("AUTO");
            terminal.clear();
            terminal.readln("cd ../st-mode");
            terminal.clear();
            terminal.readln("site state-transfer-mode get --site=NYC");
            terminal.assertContains("AUTO");
            terminal.clear();
            terminal.readln("site state-transfer-mode get --site=NOT_A_SITE");
            terminal.assertContains("Not Found: Cache 'st-mode' does not backup to site 'NOT_A_SITE'");
            terminal.clear();
            terminal.readln("site state-transfer-mode set --mode=MANUAL --site=NYC");
            terminal.clear();
            terminal.readln("site state-transfer-mode get --site=NYC");
            terminal.assertContains("MANUAL");
            terminal.clear();
            terminal.readln("site state-transfer-mode set --mode=ABC --site=NYC");
            terminal.assertContains("No enum constant org.infinispan.configuration.cache.XSiteStateTransferMode.ABC");
            terminal.clear();
        });
    }

    @Test
    public void testRelayNodeInfo() {
        this.doWithTerminal(terminal -> {
            this.connect((AeshTestConnection)terminal, "LON");
            terminal.readln("site is-relay-node");
            terminal.assertContains("true");
            terminal.clear();
            List<String> view = XSiteCliOperations.extractView(terminal);
            terminal.readln("site relay-nodes");
            view.forEach(arg_0 -> ((AeshTestConnection)terminal).assertContains(arg_0));
            terminal.clear();
        });
    }

    private void connect(AeshTestConnection terminal, String site) {
        terminal.readln("connect " + this.hostAndPort(site));
        terminal.assertContains("//containers/default]>");
        terminal.clear();
    }

    private void disconnect(AeshTestConnection terminal) {
        terminal.readln("disconnect");
        terminal.clear();
    }

    private String hostAndPort(String site) {
        for (TestServer server : SERVERS.getTestServers()) {
            if (!site.equals(server.getSiteName())) continue;
            String host = server.getDriver().getServerAddress(0).getHostAddress();
            int port = server.getDriver().getServerSocket(0, 11222).getPort();
            return host + ":" + port;
        }
        throw new IllegalStateException("Site " + site + " not found.");
    }

    private static List<String> extractView(AeshTestConnection terminal) {
        terminal.readln("describe");
        terminal.assertContains("//containers/default");
        String allOutput = terminal.getOutputBuffer();
        Pattern pattern = Pattern.compile("^\\s*\"cluster_members\"\\s*:\\s*\\[\\s+(.*)\\s+],\\s*$");
        for (String line : allOutput.split(Config.getLineSeparator())) {
            Matcher matcher = pattern.matcher(line = line.trim());
            if (!matcher.matches()) continue;
            terminal.clear();
            return Stream.of(matcher.group(1).split(",")).map(s -> s.replaceAll("[\\[\\]\"]", "")).collect(Collectors.toList());
        }
        terminal.clear();
        throw new IllegalStateException("Unable to find 'cluster_members' in:\n" + allOutput);
    }

    private void doWithTerminal(Consumer<AeshTestConnection> consumer) {
        try (AeshTestConnection terminal = new AeshTestConnection();){
            CLI.main((Shell)new AeshDelegatingShell((Connection)terminal), (String[])new String[0], (Properties)properties);
            consumer.accept(terminal);
        }
    }
}

