/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.ArrayList;
import java.util.Collection;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.transaction.lookup.RemoteTransactionManagerLookup;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.configuration.parsing.CacheParser;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HotRodTransactionalCacheOperations {
    private static final String TEST_CACHE_XML_CONFIG = "<infinispan><cache-container>  <distributed-cache-configuration name=\"%s\">    <locking isolation=\"REPEATABLE_READ\"/>    <transaction locking=\"PESSIMISTIC\" mode=\"%s\" />  </distributed-cache-configuration></cache-container></infinispan>";
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final CacheParser.TransactionMode txMode;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> txModes = new ArrayList<Object[]>();
        txModes.add(new Object[]{CacheParser.TransactionMode.NON_XA});
        txModes.add(new Object[]{CacheParser.TransactionMode.NON_DURABLE_XA});
        txModes.add(new Object[]{CacheParser.TransactionMode.FULL_XA});
        return txModes;
    }

    public HotRodTransactionalCacheOperations(CacheParser.TransactionMode txMode) {
        this.txMode = txMode;
    }

    @Test
    public void testTransactionalCache() throws Exception {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.remoteCache(this.SERVER_TEST.getMethodName()).transactionMode(TransactionMode.NON_XA).transactionManagerLookup(RemoteTransactionManagerLookup.getInstance());
        String xml = String.format(TEST_CACHE_XML_CONFIG, this.SERVER_TEST.getMethodName(), this.txMode.name());
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(config).withServerConfiguration(new StringConfiguration(xml))).create();
        TransactionManager tm = cache.getTransactionManager();
        tm.begin();
        cache.put((Object)"k", (Object)"v1");
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k"));
        tm.commit();
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k"));
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        cache.put((Object)"k2", (Object)"v1");
        Assert.assertEquals((Object)"v2", (Object)cache.get((Object)"k"));
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k2"));
        tm.rollback();
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k"));
        Assert.assertNull((Object)cache.get((Object)"k2"));
    }
}

