/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authentication;

import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.server.security.authentication.AuthenticationIT;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.digest.DigestUtil;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class RestAuthentication {
    @ClassRule
    public static InfinispanServerRule SERVERS = AuthenticationIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final Protocol protocol;
    private final String mechanism;

    @Parameterized.Parameters(name="{1}({0})")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(Common.HTTP_MECHS.size() * Common.HTTP_PROTOCOLS.size());
        for (Protocol protocol : Common.HTTP_PROTOCOLS) {
            for (Object[] mech : Common.HTTP_MECHS) {
                params.add(new Object[]{protocol, mech[0]});
            }
        }
        return params;
    }

    public RestAuthentication(Protocol protocol, String mechanism) {
        this.protocol = protocol;
        this.mechanism = mechanism;
    }

    @Test
    public void testStaticResourcesAnonymously() {
        InfinispanServerDriver serverDriver = SERVERS.getServerDriver();
        InetSocketAddress serverAddress = serverDriver.getServerSocket(0, 11222);
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder().followRedirects(false);
        builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        RestClient restClient = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        RestResponse response = (RestResponse)Common.sync(restClient.raw().get("/"));
        Assert.assertEquals((long)307L, (long)response.getStatus());
    }

    @Test
    public void testMalformedDigestHeader() throws Exception {
        Assume.assumeTrue((boolean)this.mechanism.startsWith("DIGEST"));
        InfinispanServerDriver serverDriver = SERVERS.getServerDriver();
        InetSocketAddress serverAddress = serverDriver.getServerSocket(0, 11222);
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder().followRedirects(false);
        builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        RestClient restClient = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        RestResponse response = (RestResponse)Common.sync(restClient.raw().get("/rest/v2/caches"));
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String auth = ((List)response.headers().get("Www-Authenticate")).stream().filter(h -> h.startsWith("Digest")).findFirst().get();
        HashMap parameters = DigestUtil.parseResponse((byte[])auth.substring(7).getBytes(StandardCharsets.UTF_8), (Charset)StandardCharsets.UTF_8, (boolean)false, (ElytronMessages)ElytronMessages.httpDigest);
        String realm = new String((byte[])parameters.get("realm"), StandardCharsets.UTF_8);
        String nonce = new String((byte[])parameters.get("nonce"), StandardCharsets.UTF_8);
        String opaque = new String((byte[])parameters.get("opaque"), StandardCharsets.UTF_8);
        String algorithm = new String((byte[])parameters.get("algorithm"), StandardCharsets.UTF_8);
        String charset = StandardCharsets.ISO_8859_1.name();
        MessageDigest digester = MessageDigest.getInstance(algorithm);
        String nc = "00000001";
        String cnonce = "00000000";
        String username = "h4ck0rz";
        String password = "letmein";
        String uri = "/backdoor";
        String s1 = "h4ck0rz:" + realm + ':' + "letmein";
        String s2 = "GET:/backdoor";
        String hasha1 = Util.toHexString((byte[])digester.digest(s1.getBytes(charset)));
        String h2 = Util.toHexString((byte[])digester.digest("GET:/backdoor".getBytes(charset)));
        String digestValue = hasha1 + ':' + nonce + ':' + "00000001" + ':' + "00000000" + ":auth:" + h2;
        String digest = Util.toHexString((byte[])digester.digest(digestValue.getBytes(StandardCharsets.US_ASCII.toString())));
        String authz = String.format("Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", response=\"%s\", qop=auth, nc=%s, cnonce=%s, algorithm=%s, opaque=\"%s\"", "h4ck0rz", realm, nonce, "/backdoor", digest, "00000001", "00000000", algorithm, opaque);
        response = (RestResponse)Common.sync(restClient.raw().get("/rest/v2/caches", Collections.singletonMap("Authorization", authz)));
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void testRestReadWrite() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        if (!this.mechanism.isEmpty()) {
            builder.protocol(this.protocol).security().authentication().mechanism(this.mechanism).realm("default").username("all_user").password("all");
        }
        if (this.mechanism.isEmpty()) {
            Exceptions.expectException(SecurityException.class, () -> this.SERVER_TEST.rest().withClientConfiguration(builder).create());
        } else {
            RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
            RestResponse response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).post("k1", "v1"));
            Assert.assertEquals((long)204L, (long)response.getStatus());
            Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
            response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).get("k1"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
            Assert.assertEquals((Object)"v1", (Object)response.getBody());
        }
    }
}

