/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.ldap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.core.ldap.AbstractLdapServer;

public class ApacheLdapServer
extends AbstractLdapServer {
    private static final String LDAP_HOST = "0.0.0.0";
    public static final int KDC_PORT = 6088;
    public static final int LDAP_PORT = 10389;
    public static final int LDAPS_PORT = 10636;
    public static final String DOMAIN = "dc=infinispan,dc=org";
    public static final String REALM = "INFINISPAN.ORG";
    private DirectoryService directoryService;
    private LdapServer ldapServer;
    private KdcServer kdcServer;

    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10389, address="0.0.0.0")})
    public void createLdap(String keystoreFile, String initLDIF) throws Exception {
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(initLDIF);){
            for (LdifEntry ldifEntry : new LdifReader(is)) {
                this.directoryService.getAdminSession().add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
            }
        }
        CreateLdapServer createLdapServer = (CreateLdapServer)AnnotationUtils.getInstance(CreateLdapServer.class);
        this.ldapServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)createLdapServer, (DirectoryService)this.directoryService);
        this.ldapServer.setKeystoreFile(keystoreFile);
        this.ldapServer.setCertificatePassword("secret");
        TcpTransport ldaps = new TcpTransport(10636);
        ldaps.enableSSL(true);
        this.ldapServer.addTransports(new Transport[]{ldaps});
    }

    @CreateDS(name="InfinispanDS", partitions={@CreatePartition(name="infinispan", suffix="dc=infinispan,dc=org", contextEntry=@ContextEntry(entryLdif="dn: dc=infinispan,dc=org\ndc: infinispan\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou"), @CreateIndex(attribute="uid")})})
    public void createDs() throws Exception {
        this.directoryService = DSAnnotationProcessor.getDirectoryService();
        this.directoryService.getChangeLog().setEnabled(false);
        this.directoryService.addLast((Interceptor)new KeyDerivationInterceptor());
    }

    @Override
    public void start(String keystoreFile, String initLDIF) throws Exception {
        this.createDs();
        this.createLdap(keystoreFile, initLDIF);
        this.ldapServer.start();
    }

    @Override
    public void stop() throws Exception {
        try {
            if (this.kdcServer != null) {
                this.kdcServer.stop();
                this.kdcServer = null;
            }
            this.ldapServer.stop();
            this.directoryService.shutdown();
        }
        finally {
            Util.recursiveFileRemove((File)this.directoryService.getInstanceLayout().getInstanceDirectory());
        }
    }

    @Override
    public void startKdc() throws IOException, LdapInvalidDnException {
        this.createKdc();
        this.kdcServer.start();
    }

    private void createKdc() {
        KdcServer kdcServer = new KdcServer();
        kdcServer.setServiceName("TestKDCServer");
        kdcServer.setSearchBaseDn(DOMAIN);
        KerberosConfig config = kdcServer.getConfig();
        config.setServicePrincipal("krbtgt/INFINISPAN.ORG@INFINISPAN.ORG");
        config.setPrimaryRealm(REALM);
        config.setMaximumTicketLifetime(86400000L);
        config.setMaximumRenewableLifetime(604800000L);
        config.setPaEncTimestampRequired(false);
        UdpTransport udp = new UdpTransport(LDAP_HOST, 6088);
        kdcServer.addTransports(new Transport[]{udp});
        kdcServer.setDirectoryService(this.directoryService);
        this.kdcServer = kdcServer;
    }
}

