/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.commons.util.Version;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class AnchoredKeysIT {
    @ClassRule
    public static final InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/AnchoredKeys.xml").numServers(2)).runMode(ServerRunMode.EMBEDDED)).featuresEnabled(new String[]{"anchored-keys"})).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testAnchoredKeysCache() {
        RemoteCacheManager rcm = this.SERVER_TEST.hotrod().createRemoteCacheManager();
        this.test((RemoteCache<String, String>)rcm.getCache("default"));
    }

    @Test
    public void testCreateAnchoredKeysCache() {
        StringConfiguration config = new StringConfiguration("<infinispan><cache-container><replicated-cache name=\"anchored2\">\n<locking concurrency-level=\"100\" acquire-timeout=\"1000\"/>\n<anchored-keys xmlns=\"urn:infinispan:config:anchored-keys:" + Version.getMajorMinor() + "\" enabled=\"true\"/>\n</replicated-cache></cache-container></infinispan>");
        RemoteCacheManager rcm = this.SERVER_TEST.hotrod().createRemoteCacheManager();
        rcm.administration().createCache("anchored2", (BasicConfiguration)config);
        this.test((RemoteCache<String, String>)rcm.getCache("anchored2"));
    }

    private void test(RemoteCache<String, String> cache) {
        Assert.assertNotNull(cache);
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
        Assert.assertEquals((long)1L, (long)cache.size());
    }
}

