/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestMetricsClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestMetricsResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testOpenMetrics() {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_stores";
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metrics(true));){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsOpenmetrics(response.contentType());
            String metricsText = response.getBody();
            Assert.assertTrue((boolean)metricsText.contains("# TYPE vendor_" + metricName + " gauge\n"));
            Assert.assertTrue((boolean)metricsText.contains("vendor_" + metricName + "{cache=\"" + this.SERVER_TEST.getMethodName()));
        }
    }

    @Test
    public void testBaseAndVendorMetrics() throws Exception {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            String body = response.getBody();
            RestMetricsResource.checkRule(body, "base_classloader_loadedClasses_count", stringValue -> {
                double parsed = Double.parseDouble(stringValue);
                Assertions.assertThat((double)parsed).isPositive();
            });
            RestMetricsResource.checkRule(body, "vendor_memoryPool_Metaspace_usage_bytes", stringValue -> {
                double parsed = Double.parseDouble(stringValue);
                Assertions.assertThat((double)parsed).isPositive();
            });
        }
    }

    @Test
    public void testMetrics() throws Exception {
        String body;
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String cacheName = this.SERVER_TEST.getMethodName();
        String metricName = String.format("cache_manager_default_cache_%s_statistics_stores{cache=\"%s\"", cacheName, cacheName);
        int NUM_PUTS = 10;
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            String body2 = response.getBody();
            Assertions.assertThat((String)body2).contains(new CharSequence[]{"base", "vendor", metricName});
            RestMetricsResource.checkRule(body2, "vendor_" + metricName, stringValue -> {
                double parsed = Double.parseDouble(stringValue);
                Assertions.assertThat((double)parsed).isZero();
            });
        }
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        for (int i = 0; i < NUM_PUTS; ++i) {
            RestResponse putResp = (RestResponse)Common.sync(cache.put("k" + i, "v" + i));
            Assert.assertEquals((long)204L, (long)putResp.getStatus());
        }
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            body = response.getBody();
            Assertions.assertThat((String)body).contains(new CharSequence[]{"base", "vendor", metricName});
            RestMetricsResource.checkRule(body, "vendor_" + metricName, stringValue -> {
                double parsed = Double.parseDouble(stringValue);
                Assertions.assertThat((double)parsed).isEqualTo(10.0);
            });
        }
        Common.sync(client.cache(this.SERVER_TEST.getMethodName()).delete());
        response = (RestResponse)Common.sync(metricsClient.metrics());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            body = response.getBody();
            Assertions.assertThat((String)body).contains(new CharSequence[]{"base", "vendor"});
            Assertions.assertThat((String)body).doesNotContain((CharSequence)metricName);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testTimerMetrics() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_store_times";
        int NUM_PUTS = 10;
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            String body = response.getBody();
            Assertions.assertThat((String)body).contains(new CharSequence[]{"base", "vendor", metricName});
            RestMetricsResource.checkRule(body, "vendor_" + metricName, stringValue -> {
                double parsed = Double.parseDouble(stringValue);
                Assertions.assertThat((double)parsed).isZero();
            });
        }
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        for (int i = 0; i < NUM_PUTS; ++i) {
            RestResponse putResp = (RestResponse)Common.sync(cache.put("k" + i, "v" + i));
            Assert.assertEquals((long)204L, (long)putResp.getStatus());
        }
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            String body = response.getBody();
            Assertions.assertThat((String)body).contains(new CharSequence[]{"base", "vendor", metricName});
            RestMetricsResource.checkRule(body, "vendor_" + metricName, stringValue -> {
                double parsed = Double.parseDouble(stringValue);
                Assertions.assertThat((double)parsed).isPositive();
            });
        }
    }

    @Test
    public void testMetricsMetadata() throws Exception {
        String body;
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String cacheName = this.SERVER_TEST.getMethodName();
        String metricName = String.format("cache_manager_default_cache_%s_statistics_stores{cache=\"%s\"", cacheName, cacheName);
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metricsMetadata());){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            body = response.getBody();
            Assertions.assertThat((String)body).contains(new CharSequence[]{"base", "vendor", metricName});
            RestMetricsResource.checkRule(body, "vendor_" + metricName, stringValue -> {
                double parsed = Double.parseDouble(stringValue);
                Assertions.assertThat((double)parsed).isZero();
            });
        }
        Common.sync(client.cache(this.SERVER_TEST.getMethodName()).delete());
        response = (RestResponse)Common.sync(metricsClient.metricsMetadata());
        try {
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            body = response.getBody();
            Assertions.assertThat((String)body).contains(new CharSequence[]{"base", "vendor"});
            Assertions.assertThat((String)body).doesNotContain((CharSequence)metricName);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private static Stream<Map.Entry<String, Json>> streamNodeFields(Json node) {
        if (node == null) {
            throw new IllegalArgumentException("Input node cannot be null");
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.asJsonMap().entrySet().iterator(), 1024), false);
    }

    static void checkIsPrometheus(MediaType contentType) {
        Object[] expectedContentType = "text/plain; version=0.0.4; charset=utf-8".split(";");
        Object[] actualContentType = contentType.toString().split(";");
        Assertions.assertThat((Object[])actualContentType).containsExactlyInAnyOrder(expectedContentType);
    }

    static void checkIsOpenmetrics(MediaType contentType) {
        Object[] expectedContentType = "application/openmetrics-text; version=1.0.0; charset=utf-8".split(";");
        Object[] actualContentType = contentType.toString().split(";");
        Assertions.assertThat((Object[])actualContentType).containsExactlyInAnyOrder(expectedContentType);
    }

    static void checkRule(String body, String key, Consumer<String> check) throws Exception {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(body));
        while ((line = bufferedReader.readLine()) != null) {
            if (!line.startsWith(key)) continue;
            Object[] split = line.split(" ");
            Assertions.assertThat((Object[])split).hasSize(2);
            check.accept((String)split[1]);
            return;
        }
        Assert.fail((String)("Key " + key + " not found in body"));
    }
}

