/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.net.ConnectException;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.test.Eventually;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ShutdownRestIT {
    @ClassRule
    public static final InfinispanServerRule SERVER = ((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").numServers(1)).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVER);

    @Test
    public void testShutDown() {
        RestClient client = this.SERVER_TEST.rest().create();
        Common.sync(client.server().stop());
        Eventually.eventually(() -> ShutdownRestIT.isServerShutdown(client));
        Eventually.eventually(() -> !SERVER.getServerDriver().isRunning(0));
    }

    static boolean isServerShutdown(RestClient client) {
        try {
            ((RestResponse)Common.sync(client.server().configuration())).close();
        }
        catch (RuntimeException r) {
            return Util.getRootCause((Throwable)r) instanceof ConnectException;
        }
        return false;
    }
}

