/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import org.assertj.core.api.Assertions;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestMetricsClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.server.functional.RestMetricsResource;
import org.infinispan.server.functional.XSiteIT;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;
import org.infinispan.server.test.junit4.InfinispanXSiteServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class XSiteRestMetricsOperations {
    private static final String LON_CACHE_XML_CONFIG = "<infinispan><cache-container>  <replicated-cache name=\"%s\" statistics=\"true\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>";
    private static final String NYC_CACHE_XML_CONFIG = "<infinispan><cache-container>  <replicated-cache name=\"%s\" statistics=\"true\">     <backups>        <backup site=\"LON\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>";
    @ClassRule
    public static final InfinispanXSiteServerRule SERVERS = XSiteIT.SERVERS;
    @Rule
    public InfinispanXSiteServerTestMethodRule SERVER_TEST = new InfinispanXSiteServerTestMethodRule(SERVERS);

    @Test
    public void testSiteStatus() throws Exception {
        String lonXML = String.format(LON_CACHE_XML_CONFIG, this.SERVER_TEST.getMethodName());
        String nycXML = String.format(NYC_CACHE_XML_CONFIG, this.SERVER_TEST.getMethodName());
        RestClient client = ((RestTestClientDriver)this.SERVER_TEST.rest("LON").withServerConfiguration(new StringConfiguration(lonXML))).create();
        RestMetricsClient metricsClient = client.metrics();
        ((RestTestClientDriver)this.SERVER_TEST.rest("NYC").withServerConfiguration(new StringConfiguration(nycXML))).create();
        String statusMetricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_x_site_admin_nyc_status";
        try (RestResponse response = (RestResponse)Common.sync(metricsClient.metrics(true));){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsOpenmetrics(response.contentType());
            Assert.assertTrue((boolean)response.getBody().contains("# TYPE vendor_" + statusMetricName + " gauge\n"));
        }
        XSiteRestMetricsOperations.assertSiteStatusMetrics(metricsClient, statusMetricName, 1);
        response = (RestResponse)Common.sync(client.cacheManager("default").takeOffline("NYC"));
        try {
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        XSiteRestMetricsOperations.assertSiteStatusMetrics(metricsClient, statusMetricName, 0);
    }

    private static void assertSiteStatusMetrics(RestMetricsClient client, String metric, int expected) throws Exception {
        try (RestResponse response = (RestResponse)Common.sync(client.metrics());){
            Assert.assertEquals((long)200L, (long)response.getStatus());
            RestMetricsResource.checkIsPrometheus(response.contentType());
            RestMetricsResource.checkRule(response.getBody(), "vendor_" + metric, stringValue -> {
                int parsed = (int)Double.parseDouble(stringValue);
                Assertions.assertThat((int)parsed).isEqualTo(expected);
            });
        }
    }
}

