/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.server.persistence.CustomNonBlockingStore;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.core.category.Persistence;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Persistence.class})
public class CustomStoreOperationsIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/CustomStoreTest.xml").numServers(1)).artifacts(CustomStoreOperationsIT.artifacts())).runMode(ServerRunMode.CONTAINER)).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    private static JavaArchive[] artifacts() {
        JavaArchive customStoreJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"custom-store.jar");
        customStoreJar.addClass(CustomNonBlockingStore.class);
        return new JavaArchive[]{customStoreJar};
    }

    @Test
    public void testDefineCustomStoreAndUtilize() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
        configurationBuilder.encoding().mediaType("application/x-protostream");
        ((CustomStoreConfigurationBuilder)((CustomStoreConfigurationBuilder)configurationBuilder.persistence().addStore(CustomStoreConfigurationBuilder.class)).segmented(false)).customStoreClass(CustomNonBlockingStore.class);
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withServerConfiguration(configurationBuilder)).create();
        Assert.assertEquals((Object)"Hello World", (Object)cache.get((Object)"World"));
    }
}

