/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.ldap.AbstractLdapServer;
import org.infinispan.server.test.core.ldap.ApacheLdapServer;
import org.infinispan.server.test.core.ldap.RemoteLdapServer;

public class LdapServerListener
implements InfinispanServerListener {
    public static final String LDAP_SERVER = System.getProperty("org.infinispan.test.ldapServer", "apache");
    private static final String DEFAULT_LDIF = "ldif/infinispan.ldif";
    private static final String KERBEROS_LDIF = "ldif/infinispan-kerberos.ldif";
    private AbstractLdapServer ldapServer;

    public LdapServerListener() {
        this(false);
    }

    public LdapServerListener(boolean withKdc) {
        if ("apache".equals(LDAP_SERVER)) {
            this.ldapServer = new ApacheLdapServer(withKdc, withKdc ? KERBEROS_LDIF : DEFAULT_LDIF);
        } else if ("remote".equals(LDAP_SERVER)) {
            this.ldapServer = new RemoteLdapServer(withKdc ? KERBEROS_LDIF : DEFAULT_LDIF);
        } else {
            throw new IllegalStateException("Unsupported LDAP Server: " + LDAP_SERVER);
        }
    }

    public void before(InfinispanServerDriver driver) {
        Exceptions.unchecked(() -> this.ldapServer.start(driver.getCertificateFile("server").getAbsolutePath(), driver.getConfDir()));
    }

    public void after(InfinispanServerDriver driver) {
        try {
            this.ldapServer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ThreadLeakChecker.ignoreThreadsContaining((String)"pool-.*thread-");
        ThreadLeakChecker.ignoreThreadsContaining((String)"^Thread-\\d+$");
    }
}

