/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.ldap;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.infinispan.server.test.core.ldap.AbstractLdapServer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testcontainers.shaded.com.google.common.io.Files;

public class RemoteLdapServer
extends AbstractLdapServer {
    private String initLDIF;
    private static final Log log = LogFactory.getLog(RemoteLdapServer.class);

    public RemoteLdapServer(String initLDIF) {
        this.initLDIF = initLDIF;
    }

    @Override
    public void start(String keystoreFile, File confDir) throws URISyntaxException, LdapException, IOException {
        URI ldapUri = new URI(System.getProperty("org.infinispan.test.ldap.url"));
        LdapNetworkConnection connection = new LdapNetworkConnection(ldapUri.getHost(), ldapUri.getPort());
        connection.setTimeOut(60L);
        connection.bind(System.getProperty("org.infinispan.test.ldap.principal"), System.getProperty("org.infinispan.test.ldap.credential"));
        String fullPathFile = this.getClass().getClassLoader().getResource(this.initLDIF).getFile();
        String fileContent = Files.toString((File)new File(fullPathFile), (Charset)Charset.defaultCharset());
        LdifReader ldifReader = new LdifReader();
        List entries = ldifReader.parseLdif(fileContent);
        for (LdifEntry ldifEntry : entries) {
            try {
                Entry entry = ldifEntry.getEntry();
                connection.add(entry);
            }
            catch (LdapEntryAlreadyExistsException e) {
                log.debug((Object)ldifEntry.getDn().toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
    }
}

