/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import io.jaegertracing.testcontainers.JaegerAllInOne;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.Eventually;
import org.infinispan.server.test.core.Containers;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.testcontainers.containers.GenericContainer;

public class RequestTracingIT {
    public static final String JAEGER_IMAGE = System.getProperty("org.infinispan.test.jaegerImage", "quay.io/jaegertracing/all-in-one:latest");
    public static final String SERVICE_NAME = RequestTracingIT.class.getName();
    public static final int NUM_KEYS = 10;
    private static JaegerAllInOne JAEGER = new JaegerAllInOne(JAEGER_IMAGE);
    @ClassRule
    public static final InfinispanServerRule SERVER = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").runMode(ServerRunMode.CONTAINER)).numServers(1)).mavenArtifacts(new String[]{"io.jaegertracing:jaeger-core:0.34.3", "io.jaegertracing:jaeger-thrift:0.34.3", "io.jaegertracing:jaeger-tracerresolver:0.34.3", "io.opentracing.contrib:opentracing-tracerresolver:0.1.5", "org.slf4j:slf4j-api:1.7.25", "com.squareup.okhttp3:okhttp:3.14.4", "com.squareup.okio:okio:1.13.0", "org.apache.thrift:libthrift:0.13.0", "io.opentracing:opentracing-api:0.31.0", "io.opentracing:opentracing-util:0.31.0", "io.opentracing:opentracing-noop:0.31.0", "org.slf4j:slf4j-jdk14:1.7.5"})).property("infinispan.opentracing.factory.class", "io.jaegertracing.tracerresolver.internal.JaegerTracerFactory")).property("infinispan.opentracing.factory.method", "getTracer")).property("JAEGER_SERVICE_NAME", SERVICE_NAME)).property("JAEGER_SAMPLER_TYPE", "const")).property("JAEGER_SAMPLER_PARAM", "1")).property("JAEGER_REPORTER_LOG_SPANS", "true")).property("JAEGER_REPORTER_MAX_QUEUE_SIZE", "1")).property("JAEGER_REPORTER_FLUSH_INTERVAL", "1")).addListener(new InfinispanServerListener(){

        public void before(InfinispanServerDriver driver) {
            JAEGER.start();
            String endpoint = String.format("http://%s:%s/api/traces", Containers.ipAddress((GenericContainer)JAEGER), 14268);
            driver.getConfiguration().properties().setProperty("JAEGER_ENDPOINT", endpoint);
        }

        public void after(InfinispanServerDriver driver) {
            JAEGER.stop();
        }
    })).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVER);

    @Test
    public void testRequestIsTraced() {
        RemoteCache remoteCache = this.SERVER_TEST.hotrod().create();
        for (int i = 0; i < 10; ++i) {
            remoteCache.put((Object)("key" + i), (Object)"value");
        }
        OkHttpClient httpClient = new OkHttpClient();
        String queryUrl = String.format("http://%s:%s/api/traces?service=%s", Containers.ipAddress((GenericContainer)JAEGER), 16686, SERVICE_NAME);
        Eventually.eventually(() -> {
            try (Response response = httpClient.newCall(new Request.Builder().url(queryUrl).build()).execute();){
                if (response.body() == null) {
                    boolean bl = false;
                    return bl;
                }
                Json json = Json.read((String)response.body().string());
                boolean bl = json.has("data") && !json.at("data").asList().isEmpty();
                return bl;
            }
        });
    }
}

