/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.concurrent.CompletionStage;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.Eventually;
import org.infinispan.server.functional.XSiteIT;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;
import org.infinispan.server.test.junit4.InfinispanXSiteServerTestMethodRule;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class XSiteRestCacheOperations {
    @ClassRule
    public static final InfinispanXSiteServerRule SERVERS = XSiteIT.SERVERS;
    @Rule
    public InfinispanXSiteServerTestMethodRule SERVER_TEST = new InfinispanXSiteServerTestMethodRule(SERVERS);
    String cacheName;
    private RestCacheClient lonCache;
    private RestCacheClient nycCache;

    private static void assertStatus(int status, CompletionStage<RestResponse> stage) {
        Assert.assertEquals((long)status, (long)((RestResponse)CompletionStages.join(stage)).getStatus());
    }

    private static String bodyOf(CompletionStage<RestResponse> stage) {
        RestResponse rsp = (RestResponse)CompletionStages.join(stage);
        return rsp.getStatus() == 200 ? rsp.getBody() : null;
    }

    @Before
    public void setup() {
        this.cacheName = this.SERVER_TEST.getMethodName();
    }

    @Test
    public void testRestOperationsLonToNycBackup() {
        String lonXML = String.format("<infinispan><cache-container>  <replicated-cache name=\"%s\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>", this.cacheName);
        this.lonCache = this.createRestCacheClient("LON", lonXML);
        this.nycCache = this.createRestCacheClient("NYC");
        this.insertAndVerifyEntries(false);
    }

    @Test
    public void testRestOperationsAllSitesBackup() {
        String lonXML = String.format("<infinispan><cache-container>  <replicated-cache name=\"%s\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>", this.cacheName);
        String nycXML = String.format("<infinispan><cache-container>  <replicated-cache name=\"%s\">     <backups>        <backup site=\"LON\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>", this.cacheName);
        this.lonCache = this.createRestCacheClient("LON", lonXML);
        this.nycCache = this.createRestCacheClient("NYC", nycXML);
        this.insertAndVerifyEntries(true);
    }

    @Test
    public void testBackupStatus() {
        String lonXML = String.format("<infinispan><cache-container>  <replicated-cache name=\"%s\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>", this.cacheName);
        this.lonCache = this.createRestCacheClient("LON", lonXML);
        this.nycCache = this.createRestCacheClient("NYC");
        Assert.assertNull((Object)XSiteRestCacheOperations.bodyOf(this.nycCache.xsiteBackups()));
        Assert.assertEquals((long)3L, (long)Json.read((String)XSiteRestCacheOperations.bodyOf(this.lonCache.backupStatus("NYC"))).asMap().size());
        Assert.assertNull((Object)XSiteRestCacheOperations.bodyOf(this.nycCache.backupStatus("LON")));
        Json lonXsiteBackups = Json.read((String)XSiteRestCacheOperations.bodyOf(this.lonCache.xsiteBackups()));
        Assert.assertEquals((Object)"online", (Object)((Json)((Json)lonXsiteBackups.asJsonMap().get("NYC")).asJsonMap().get("status")).asString());
        CompletionStages.join((CompletionStage)this.lonCache.takeSiteOffline("NYC"));
        lonXsiteBackups = Json.read((String)XSiteRestCacheOperations.bodyOf(this.lonCache.xsiteBackups()));
        Assert.assertTrue((boolean)((Json)((Json)lonXsiteBackups.asJsonMap().get("NYC")).asJsonMap().get("status")).asString().contains("offline"));
        CompletionStages.join((CompletionStage)this.lonCache.bringSiteOnline("NYC"));
        lonXsiteBackups = Json.read((String)XSiteRestCacheOperations.bodyOf(this.lonCache.xsiteBackups()));
        Assert.assertTrue((boolean)((Json)((Json)lonXsiteBackups.asJsonMap().get("NYC")).asJsonMap().get("status")).asString().contains("online"));
    }

    @Test
    public void testWithDifferentCacheNames() {
        this.lonCache = this.createRestCacheClient("LON", "<infinispan><cache-container>  <replicated-cache name=\"lon-cache\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>     <backup-for remote-cache=\"nyc-cache\" remote-site=\"NYC\" />  </replicated-cache></cache-container></infinispan>");
        this.nycCache = this.createRestCacheClient("NYC", "<infinispan><cache-container>  <replicated-cache name=\"nyc-cache\">     <backups>        <backup site=\"LON\" strategy=\"ASYNC\"/>     </backups>     <backup-for remote-cache=\"lon-cache\" remote-site=\"LON\" />  </replicated-cache></cache-container></infinispan>");
        this.insertAndVerifyEntries(true);
    }

    @Test
    public void testHotRodOperationsWithOffHeapSingleFileStore() {
        String lonXML = String.format("<infinispan><cache-container statistics=\"true\"><distributed-cache name=\"%s\" owners=\"2\" mode=\"ASYNC\" remote-timeout=\"25000\" statistics=\"true\">        <backups>            <backup site=\"NYC\" strategy=\"ASYNC\" timeout=\"30000\">                <take-offline after-failures=\"-1\" min-wait=\"60000\"/>            </backup>        </backups>        <memory storage=\"OFF_HEAP\" max-count=\"100\" when-full=\"REMOVE\"/>        <persistence passivation=\"true\">     <file-store shared=\"false\" preload=\"true\" purge=\"false\" />  </persistence>  </distributed-cache></cache-container></infinispan>", this.cacheName);
        this.lonCache = this.createRestCacheClient("LON", lonXML);
        this.nycCache = this.createRestCacheClient("NYC");
        Assert.assertEquals((long)0L, (long)this.getTotalMemoryEntries(this.lonCache));
        IntStream.range(0, 300).forEach(i -> {
            String s = Integer.toString(i);
            XSiteRestCacheOperations.bodyOf(this.lonCache.put(s, s));
        });
        Eventually.eventuallyEquals((Object)"300", () -> XSiteRestCacheOperations.bodyOf(this.nycCache.size()));
        Assert.assertEquals((long)100L, (long)this.getTotalMemoryEntries(this.lonCache));
    }

    private int getTotalMemoryEntries(RestCacheClient restCache) {
        Json json = Json.read((String)((RestResponse)Common.sync(restCache.stats())).getBody());
        return ((Json)json.asJsonMap().get("current_number_of_entries_in_memory")).asInteger();
    }

    private void insertAndVerifyEntries(boolean allSitesBackup) {
        XSiteRestCacheOperations.assertStatus(204, this.lonCache.put("k1", "v1"));
        XSiteRestCacheOperations.assertStatus(204, this.nycCache.put("k2", "v2"));
        Assert.assertEquals((Object)"v1", (Object)XSiteRestCacheOperations.bodyOf(this.lonCache.get("k1")));
        Eventually.eventuallyEquals((Object)"v1", () -> XSiteRestCacheOperations.bodyOf(this.nycCache.get("k1")));
        Assert.assertEquals((Object)"v2", (Object)XSiteRestCacheOperations.bodyOf(this.nycCache.get("k2")));
        if (allSitesBackup) {
            Eventually.eventuallyEquals((Object)"v2", () -> XSiteRestCacheOperations.bodyOf(this.lonCache.get("k2")));
        } else {
            Assert.assertEquals(null, (Object)XSiteRestCacheOperations.bodyOf(this.lonCache.get("k2")));
        }
    }

    private RestCacheClient createRestCacheClient(String siteName, String xml) {
        RestCacheClient cache = this.SERVER_TEST.rest(siteName).get().cache(this.cacheName);
        XSiteRestCacheOperations.assertStatus(200, cache.createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)xml), new CacheContainerAdmin.AdminFlag[0]));
        return cache;
    }

    private RestCacheClient createRestCacheClient(String siteName) {
        RestCacheClient cache = this.SERVER_TEST.rest(siteName).get().cache(this.cacheName);
        XSiteRestCacheOperations.assertStatus(200, cache.createWithTemplate(DefaultTemplate.DIST_SYNC.getTemplateName(), new CacheContainerAdmin.AdminFlag[0]));
        return cache;
    }
}

