/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authentication;

import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.server.security.authentication.AuthenticationIT;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class RespAuthentication {
    @ClassRule
    public static InfinispanServerRule SERVERS = AuthenticationIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestReadWrite() {
        InetSocketAddress serverSocket = SERVERS.getServerDriver().getServerSocket(0, 11222);
        RedisClient client = RedisClient.create((String)String.format("redis://all_user:all@%s:%d", serverSocket.getHostName(), serverSocket.getPort()));
        try (StatefulRedisConnection redisConnection = client.connect();){
            RedisCommands redis = redisConnection.sync();
            redis.set((Object)"k1", (Object)"v1");
            redis.set((Object)"k3", (Object)"v3");
            redis.set((Object)"k4", (Object)"v4");
            ArrayList<KeyValue> expected = new ArrayList<KeyValue>(4);
            expected.add(KeyValue.just((Object)"k1", (Object)"v1"));
            expected.add(KeyValue.empty((Object)"k2"));
            expected.add(KeyValue.just((Object)"k3", (Object)"v3"));
            expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
            List results = redis.mget((Object[])new String[]{"k1", "k2", "k3", "k4"});
            Assert.assertEquals(expected, (Object)results);
        }
        finally {
            client.shutdown();
        }
    }
}

