/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.infinispan.client.hotrod.security.BasicCallbackHandler;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.test.TestingUtil;
import org.junit.Assert;

public class Common {
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");
    public static final Collection<Object[]> SASL_MECHS;
    public static final Collection<Object[]> SASL_KERBEROS_MECHS;
    public static final Collection<Object[]> HTTP_MECHS;
    public static final Collection<Object[]> HTTP_KERBEROS_MECHS;
    public static final Collection<Protocol> HTTP_PROTOCOLS;
    public static final String[] NASHORN_DEPS;

    public static RestResponse awaitStatus(Supplier<CompletionStage<RestResponse>> request, int pendingStatus, int completeStatus) {
        RestResponse response;
        int count = 0;
        while ((response = (RestResponse)FunctionalTestUtils.await(request.get())).getStatus() == pendingStatus || count++ < 100) {
            response.close();
            TestingUtil.sleepThread((long)10L);
        }
        Assert.assertEquals((long)completeStatus, (long)response.getStatus());
        return response;
    }

    public static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(5L, TimeUnit.SECONDS));
    }

    public static <T> T sync(CompletionStage<T> stage, long timeout, TimeUnit timeUnit) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(timeout, timeUnit));
    }

    public static void assertStatus(int status, CompletionStage<RestResponse> request) {
        try (RestResponse response = Common.sync(request);){
            Assert.assertEquals((long)status, (long)response.getStatus());
        }
    }

    public static Subject createSubject(String principal, String realm, char[] password) {
        return (Subject)Exceptions.unchecked(() -> {
            LoginContext context = new LoginContext("KDC", null, (CallbackHandler)new BasicCallbackHandler(principal, realm, password), Common.createJaasConfiguration(false));
            context.login();
            return context.getSubject();
        });
    }

    private static javax.security.auth.login.Configuration createJaasConfiguration(final boolean server) {
        return new javax.security.auth.login.Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"KDC".equals(name)) {
                    throw new IllegalArgumentException(String.format("Unexpected name '%s'", name));
                }
                AppConfigurationEntry[] entries = new AppConfigurationEntry[1];
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("refreshKrb5Config", "true");
                if (IS_IBM) {
                    options.put("noAddress", "true");
                    options.put("credsType", server ? "acceptor" : "initiator");
                    entries[0] = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                } else {
                    options.put("storeKey", "true");
                    options.put("isInitiator", server ? "false" : "true");
                    entries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                }
                return entries;
            }
        };
    }

    public static String cacheConfigToJson(String name, Configuration configuration) {
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).prettyPrint(false).build();){
            new ParserRegistry().serialize(w, name, configuration);
        }
        return sw.toString();
    }

    static {
        HTTP_PROTOCOLS = Arrays.asList(Protocol.values());
        NASHORN_DEPS = new String[]{"org.openjdk.nashorn:nashorn-core:15.3", "org.ow2.asm:asm:7.3.1", "org.ow2.asm:asm-util:7.3.1"};
        SASL_MECHS = new ArrayList<Object[]>();
        SASL_MECHS.add(new Object[]{""});
        SASL_MECHS.add(new Object[]{"PLAIN"});
        SASL_MECHS.add(new Object[]{"DIGEST-MD5"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-512"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-384"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-256"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-512"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-384"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-256"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-1"});
        SASL_KERBEROS_MECHS = new ArrayList<Object[]>();
        SASL_KERBEROS_MECHS.add(new Object[]{""});
        SASL_KERBEROS_MECHS.add(new Object[]{"GSSAPI"});
        SASL_KERBEROS_MECHS.add(new Object[]{"GS2-KRB5"});
        HTTP_MECHS = new ArrayList<Object[]>();
        HTTP_MECHS.add(new Object[]{""});
        HTTP_MECHS.add(new Object[]{"BASIC"});
        HTTP_MECHS.add(new Object[]{"DIGEST"});
        HTTP_KERBEROS_MECHS = new ArrayList<Object[]>();
        HTTP_KERBEROS_MECHS.add(new Object[]{""});
        HTTP_KERBEROS_MECHS.add(new Object[]{"SPNEGO"});
    }
}

