/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.ServerConfigurationBuilder;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.util.KeyValuePair;
import org.junit.After;

class AbstractMultiClusterIT {
    protected final String config;
    protected final String[] mavenArtifacts;
    protected Cluster source;
    protected Cluster target;

    public AbstractMultiClusterIT(String config, String ... mavenArtifacts) {
        this.config = config;
        this.mavenArtifacts = mavenArtifacts;
    }

    @After
    public void cleanup() throws Exception {
        this.stopSourceCluster();
        this.stopTargetCluster();
    }

    protected void startSourceCluster() {
        this.source = new Cluster(new ClusterConfiguration(this.config, 2, 0, this.mavenArtifacts), this.getCredentials());
        this.source.start(this.getClass().getName() + "-source");
    }

    protected void stopSourceCluster() throws Exception {
        if (this.source != null) {
            this.source.stop(this.getClass().getName() + "-source");
        }
    }

    protected void startTargetCluster() {
        this.target = new Cluster(new ClusterConfiguration(this.config, 2, 1000, this.mavenArtifacts), this.getCredentials());
        this.target.start(this.getClass().getName() + "-target");
    }

    protected void stopTargetCluster() throws Exception {
        if (this.target != null) {
            this.target.stop(this.getClass().getName() + "-target");
        }
    }

    protected int getCacheSize(String cacheName, RestClient restClient) {
        RestCacheClient cache = restClient.cache(cacheName);
        return Integer.parseInt(Common.assertStatus(200, cache.size()));
    }

    protected void addSchema(RestClient client) {
        RestCacheClient cache = client.cache("___protobuf_metadata");
        Common.assertStatus(204, cache.put("schema.proto", "message Person {required string name = 1;}"));
        Common.assertStatus(404, client.cache("___protobuf_metadata").get("schema.proto.errors"));
    }

    protected void createCache(String cacheName, ConfigurationBuilder builder, RestClient client) {
        String cacheConfig = Common.cacheConfigToJson(cacheName, builder.build());
        StringRestEntityOkHttp body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, cacheConfig);
        Common.assertStatus(200, client.cache(cacheName).createWithConfiguration((RestEntity)body, new CacheContainerAdmin.AdminFlag[0]));
    }

    protected KeyValuePair<String, String> getCredentials() {
        return null;
    }

    static class Cluster {
        final AbstractInfinispanServerDriver driver;
        final Map<Integer, RestClient> serverClients = new HashMap<Integer, RestClient>();
        private final KeyValuePair<String, String> credentials;

        Cluster(ClusterConfiguration simpleConfiguration) {
            this(simpleConfiguration, null);
        }

        Cluster(ClusterConfiguration simpleConfiguration, KeyValuePair<String, String> credentials) {
            this.credentials = credentials;
            Properties sysProps = System.getProperties();
            for (String prop : sysProps.stringPropertyNames()) {
                if (!prop.startsWith("org.infinispan.test.server.")) continue;
                simpleConfiguration.properties().put(prop, sysProps.getProperty(prop));
            }
            this.driver = simpleConfiguration.runMode().newDriver((InfinispanServerTestConfiguration)simpleConfiguration);
        }

        void start(String name) {
            this.driver.prepare(name);
            this.driver.start(name);
        }

        void stop(String name) throws Exception {
            this.driver.stop(name);
            for (RestClient client : this.serverClients.values()) {
                client.close();
            }
        }

        Set<String> getMembers() {
            String response = Common.assertStatus(200, this.getClient().cacheManager("default").info());
            Json jsonNode = Json.read((String)response);
            return jsonNode.at("cluster_members").asJsonList().stream().map(Json::asString).collect(Collectors.toSet());
        }

        int getSinglePort(int server) {
            return this.driver.getServerSocket(server, 11222).getPort();
        }

        RestClient getClient() {
            return this.getClient(0);
        }

        RestClient getClient(int server) {
            return this.serverClients.computeIfAbsent(server, k -> {
                InetSocketAddress serverSocket = this.driver.getServerSocket(server, 11222);
                ServerConfigurationBuilder configurationBuilder = new RestClientConfigurationBuilder().addServer().host(serverSocket.getHostName()).port(serverSocket.getPort());
                if (this.credentials != null) {
                    String user = (String)this.credentials.getKey();
                    String pass = (String)this.credentials.getValue();
                    configurationBuilder.security().authentication().enable().mechanism("BASIC").username(user).password(pass);
                }
                return RestClient.forConfiguration((RestClientConfiguration)configurationBuilder.build());
            });
        }
    }

    protected static class ClusterConfiguration
    extends InfinispanServerTestConfiguration {
        public ClusterConfiguration(String configurationFile, int numServers, int portOffset, String[] mavenArtifacts) {
            super(configurationFile, numServers, mavenArtifacts != null ? ServerRunMode.CONTAINER : ServerRunMode.EMBEDDED, new Properties(), mavenArtifacts, null, false, false, false, Collections.emptyList(), null, portOffset, new String[0]);
        }
    }
}

