/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestClusterClient;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.Element;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.server.functional.AbstractMultiClusterIT;
import org.infinispan.server.test.core.Common;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BackupManagerIT
extends AbstractMultiClusterIT {
    static final File WORKING_DIR = new File(CommonsTestingUtil.tmpDirectory(BackupManagerIT.class));
    static final int NUM_ENTRIES = 10;

    public BackupManagerIT() {
        super("configuration/ClusteredServerTest.xml", Common.NASHORN_DEPS);
    }

    @BeforeClass
    public static void setup() {
        WORKING_DIR.mkdirs();
    }

    @AfterClass
    public static void teardown() {
        Util.recursiveFileRemove((File)WORKING_DIR);
    }

    @Test
    public void testManagerBackupUpload() throws Exception {
        String name = "testManagerBackup";
        this.performTest(client -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.createBackup(name));
            return BackupManagerIT.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.restore(name, zip));
            return BackupManagerIT.awaitCreated(() -> cm.getRestore(name));
        }, this::assertWildcardContent, false);
    }

    @Test
    public void testManagerBackupFromFile() throws Exception {
        String name = "testManagerBackup";
        this.performTest(client -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.createBackup(name));
            return BackupManagerIT.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.restore(name, zip.getPath(), null));
            return BackupManagerIT.awaitCreated(() -> cm.getRestore(name));
        }, this::assertWildcardContent, true);
    }

    @Test
    public void testManagerBackupParameters() throws Exception {
        String name = "testManagerBackupParameters";
        this.performTest(client -> {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("caches", Collections.singletonList("*"));
            params.put("counters", Collections.singletonList("weak-volatile"));
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.createBackup(name, params));
            return BackupManagerIT.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("caches", Collections.singletonList("cache1"));
            params.put("counters", Collections.singletonList("*"));
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.restore(name, zip, params));
            return BackupManagerIT.awaitCreated(() -> cm.getRestore(name));
        }, client -> {
            Common.assertStatusAndBodyEquals(200, "[\"___protobuf_metadata\",\"memcachedCache\",\"cache1\",\"___script_cache\"]", client.caches());
            Common.assertStatusAndBodyEquals(200, "[\"weak-volatile\"]", client.counters());
            Common.assertStatus(404, client.schemas().get("schema.proto"));
            Common.assertStatusAndBodyEquals(200, "[]", client.tasks().list(RestTaskClient.ResultType.USER));
        }, false);
    }

    @Test
    public void testCreateDuplicateBackupResources() throws Exception {
        String backupName = "testCreateDuplicateBackupResources";
        this.startSourceCluster();
        RestClient client = this.source.getClient();
        this.populateContainer(client);
        RestCacheManagerClient cm = client.cacheManager("clustered");
        Common.assertStatus(202, cm.createBackup(backupName));
        Common.assertStatus(409, cm.createBackup(backupName));
        Common.assertStatus(202, cm.deleteBackup(backupName));
        Common.awaitStatus(() -> cm.deleteBackup(backupName), 202, 204);
        Common.assertStatus(404, cm.deleteBackup(backupName));
        Common.assertStatus(202, cm.createBackup(backupName));
        Common.awaitStatus(() -> cm.getBackup(backupName, false), 202, 200);
        Common.assertStatus(204, cm.deleteBackup(backupName));
    }

    @Test
    public void testManagerRestoreParameters() throws Exception {
        String name = "testManagerRestoreParameters";
        this.performTest(client -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.createBackup(name));
            return BackupManagerIT.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("tasks", Collections.singletonList("scripts/test.js"));
            RestCacheManagerClient cm = client.cacheManager("clustered");
            Common.assertStatus(202, cm.restore(name, zip, params));
            return BackupManagerIT.awaitCreated(() -> cm.getRestore(name));
        }, client -> {
            List tasks = Json.read((String)Common.assertStatus(200, client.tasks().list(RestTaskClient.ResultType.USER))).asJsonList();
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"scripts/test.js", (Object)((Json)tasks.iterator().next()).at("name").asString());
            Common.assertStatusAndBodyEquals(200, "[\"___protobuf_metadata\",\"memcachedCache\",\"___script_cache\"]", client.caches());
            Common.assertStatusAndBodyEquals(200, "[]", client.counters());
            Common.assertStatus(404, client.schemas().get("schema.proto"));
        }, false);
    }

    @Test
    public void testClusterBackupUpload() throws Exception {
        String name = "testClusterBackup";
        this.performTest(client -> {
            RestClusterClient cluster = client.cluster();
            Common.assertStatus(202, cluster.createBackup(name));
            return BackupManagerIT.awaitOk(() -> cluster.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestClusterClient c = client.cluster();
            Common.assertStatus(202, c.restore(name, zip));
            return BackupManagerIT.awaitCreated(() -> c.getRestore(name));
        }, this::assertWildcardContent, false);
    }

    @Test
    public void testClusterBackupFromFile() throws Exception {
        String name = "testClusterBackup";
        this.performTest(client -> {
            RestClusterClient cluster = client.cluster();
            Common.assertStatus(202, cluster.createBackup(name));
            return BackupManagerIT.awaitOk(() -> cluster.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestClusterClient c = client.cluster();
            Common.assertStatus(202, c.restore(name, zip.getPath()));
            return BackupManagerIT.awaitCreated(() -> c.getRestore(name));
        }, this::assertWildcardContent, true);
    }

    private static RestResponse awaitOk(Supplier<CompletionStage<RestResponse>> request) {
        return Common.awaitResponse(request, 202, 200);
    }

    private static RestResponse awaitCreated(Supplier<CompletionStage<RestResponse>> request) {
        return Common.awaitResponse(request, 202, 201);
    }

    private void performTest(Function<RestClient, RestResponse> backupAndDownload, Function<RestClient, RestResponse> delete, BiFunction<File, RestClient, RestResponse> restore, Consumer<RestClient> assertTargetContent, boolean syncToServer) throws Exception {
        this.startSourceCluster();
        RestClient client = this.source.getClient();
        this.populateContainer(client);
        RestResponse getResponse = backupAndDownload.apply(client);
        String fileName = getResponse.getHeader("Content-Disposition").split("=")[1];
        try (RestResponse deleteResponse = delete.apply(client);){
            Assert.assertEquals((long)204L, (long)deleteResponse.getStatus());
        }
        Thread.sleep(50L);
        this.assertNoServerBackupFilesExist(this.source);
        this.stopSourceCluster();
        this.startTargetCluster();
        client = this.target.getClient();
        File backupZip = new File(WORKING_DIR, fileName);
        try (InputStream is = getResponse.getBodyAsStream();){
            Files.copy(is, backupZip.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        getResponse.close();
        if (syncToServer) {
            backupZip = new File(this.target.driver.syncFilesToServer(0, backupZip.getAbsolutePath()));
        }
        try (RestResponse restoreResponse = restore.apply(backupZip, client);){
            Assert.assertEquals((String)restoreResponse.getBody(), (long)201L, (long)restoreResponse.getStatus());
        }
        assertTargetContent.accept(this.target.getClient(1));
        this.assertNoServerBackupFilesExist(this.target);
        this.stopTargetCluster();
    }

    private void populateContainer(RestClient client) throws Exception {
        String cacheName = "cache1";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.createCache(cacheName, builder, client);
        RestCacheClient cache = client.cache(cacheName);
        for (int i = 0; i < 10; ++i) {
            Common.assertStatus(204, cache.put(String.valueOf(i), "Val-" + i));
        }
        Assert.assertEquals((long)10L, (long)this.getCacheSize(cacheName, client));
        this.createCounter("weak-volatile", Element.WEAK_COUNTER, Storage.VOLATILE, client, 0L);
        this.createCounter("weak-persistent", Element.WEAK_COUNTER, Storage.PERSISTENT, client, -100L);
        this.createCounter("strong-volatile", Element.STRONG_COUNTER, Storage.VOLATILE, client, 50L);
        this.createCounter("strong-persistent", Element.STRONG_COUNTER, Storage.PERSISTENT, client, 0L);
        this.addSchema(client);
        try (InputStream is = BackupManagerIT.class.getResourceAsStream("/scripts/test.js");){
            String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
            Common.assertStatus(200, client.tasks().uploadScript("scripts/test.js", RestEntity.create((MediaType)MediaType.APPLICATION_JAVASCRIPT, (String)script)));
        }
    }

    private void assertWildcardContent(RestClient client) {
        String cacheName = "cache1";
        RestCacheClient cache = client.cache(cacheName);
        Common.assertStatusAndBodyEquals(200, Integer.toString(10), cache.size());
        for (int i = 0; i < 10; ++i) {
            String index = String.valueOf(i);
            Common.assertStatusAndBodyEquals(200, "Val-" + index, cache.get(index));
        }
        this.assertCounter(client, "weak-volatile", Element.WEAK_COUNTER, Storage.VOLATILE, 0L);
        this.assertCounter(client, "weak-persistent", Element.WEAK_COUNTER, Storage.PERSISTENT, -100L);
        this.assertCounter(client, "strong-volatile", Element.STRONG_COUNTER, Storage.VOLATILE, 50L);
        this.assertCounter(client, "strong-persistent", Element.STRONG_COUNTER, Storage.PERSISTENT, 0L);
        Common.assertStatusAndBodyContains(200, "message Person", client.schemas().get("schema.proto"));
        Json json = Json.read((String)Common.assertStatus(200, client.tasks().list(RestTaskClient.ResultType.USER)));
        Assert.assertTrue((boolean)json.isArray());
        List tasks = json.asJsonList();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"scripts/test.js", (Object)((Json)tasks.get(0)).at("name").asString());
    }

    private void createCounter(String name, Element type, Storage storage, RestClient client, long delta) {
        String config = String.format("{\n    \"%s\":{\n        \"initial-value\":0,\n        \"storage\":\"%s\"\n    }\n}", type, storage.toString());
        RestCounterClient counterClient = client.counter(name);
        Common.assertStatus(200, counterClient.create(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)config)));
        if (delta != 0L) {
            Assert.assertNotNull((Object)Common.assertStatus(name.contains("strong") ? 200 : 204, counterClient.add(delta)));
        }
    }

    private void assertCounter(RestClient client, String name, Element type, Storage storage, long expectedValue) {
        RestResponse rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)client.counter(name).configuration());
        Assert.assertEquals((long)200L, (long)rsp.getStatus());
        String content = rsp.getBody();
        Json config = Json.read((String)content).at(type.toString());
        Assert.assertEquals((Object)storage.toString(), (Object)config.at("storage").asString());
        Assert.assertEquals((long)0L, (long)config.at("initial-value").asInteger());
        Common.assertStatusAndBodyEquals(200, Long.toString(expectedValue), client.counter(name).get());
    }

    private void assertNoServerBackupFilesExist(AbstractMultiClusterIT.Cluster cluster) {
        for (int i = 0; i < 2; ++i) {
            cluster.driver.syncFilesFromServer(i, "data");
            Path root = cluster.driver.getRootDir().toPath();
            File workingDir = root.resolve(Integer.toString(i)).resolve("data").resolve("backups").toFile();
            Assert.assertTrue((boolean)workingDir.isDirectory());
            Object[] files = workingDir.list();
            Assert.assertNotNull((Object)files);
            Assert.assertEquals((String)Arrays.toString(files), (long)0L, (long)files.length);
        }
    }
}

