/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestClient;
import org.infinispan.commons.test.Eventually;
import org.infinispan.server.functional.ShutdownRestIT;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ConcurrentShutdownRestIT {
    @ClassRule
    public static final InfinispanServerRule SERVER = ((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").numServers(2)).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVER);

    @Test
    public void testShutDown() {
        RestClient client0 = this.SERVER_TEST.rest().create();
        RestClient client1 = this.SERVER_TEST.rest().get(1);
        CompletionStage stop0 = client0.server().stop();
        CompletionStage stop1 = client1.server().stop();
        Common.assertStatus(204, stop0);
        Common.assertStatus(204, stop1);
        Eventually.eventually(() -> ShutdownRestIT.isServerShutdown(client0));
        Eventually.eventually(() -> ShutdownRestIT.isServerShutdown(client1));
        Eventually.eventually(() -> !SERVER.getServerDriver().isRunning(0));
        Eventually.eventually(() -> !SERVER.getServerDriver().isRunning(1));
    }
}

