/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class HotRodAdmin {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testCreateDeleteCache() {
        RemoteCacheManager rcm = this.SERVER_TEST.hotrod().createRemoteCacheManager();
        String cacheName = "testCreateDeleteCache";
        String config = String.format("<infinispan><cache-container><distributed-cache name=\"%s\"/></cache-container></infinispan>", cacheName);
        RemoteCache cache = rcm.administration().createCache(cacheName, (BasicConfiguration)new StringConfiguration(config));
        cache.put((Object)"k", (Object)"v");
        Assert.assertNotNull((Object)cache.get((Object)"k"));
        rcm.administration().removeCache(cacheName);
        Assert.assertNull((Object)rcm.getCache(cacheName));
    }

    @Test
    public void testCreateDeleteCacheFragment() {
        RemoteCacheManager rcm = this.SERVER_TEST.hotrod().createRemoteCacheManager();
        String cacheName = "testCreateDeleteCacheFragment";
        String config = String.format("<distributed-cache name=\"%s\"/>", cacheName);
        RemoteCache cache = rcm.administration().createCache(cacheName, (BasicConfiguration)new StringConfiguration(config));
        cache.put((Object)"k", (Object)"v");
        Assert.assertNotNull((Object)cache.get((Object)"k"));
        rcm.administration().removeCache(cacheName);
        Assert.assertNull((Object)rcm.getCache(cacheName));
    }

    @Test
    public void testCreateDeleteTemplate() {
        RemoteCacheManager rcm = this.SERVER_TEST.hotrod().createRemoteCacheManager();
        String templateName = "template";
        String template = String.format("<infinispan><cache-container><distributed-cache name=\"%s\"/></cache-container></infinispan>", templateName);
        rcm.administration().createTemplate(templateName, (BasicConfiguration)new StringConfiguration(template));
        RemoteCache cache = rcm.administration().createCache("testCreateDeleteTemplate", templateName);
        cache.put((Object)"k", (Object)"v");
        Assert.assertNotNull((Object)cache.get((Object)"k"));
        rcm.administration().removeTemplate(templateName);
        Exceptions.expectException(HotRodClientException.class, () -> rcm.administration().createCache("anotherCache", templateName));
    }

    @Test
    public void testCreateDeleteTemplateFragment() {
        RemoteCacheManager rcm = this.SERVER_TEST.hotrod().createRemoteCacheManager();
        String templateName = "templateFragment";
        String template = String.format("<distributed-cache name=\"%s\"/>", templateName);
        rcm.administration().createTemplate(templateName, (BasicConfiguration)new StringConfiguration(template));
        RemoteCache cache = rcm.administration().createCache("testCreateDeleteTemplateFragment", templateName);
        cache.put((Object)"k", (Object)"v");
        Assert.assertNotNull((Object)cache.get((Object)"k"));
        rcm.administration().removeTemplate(templateName);
        Exceptions.expectException(HotRodClientException.class, () -> rcm.administration().createCache("anotherCache", templateName));
    }
}

