/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import io.jaegertracing.testcontainers.JaegerAllInOne;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.Eventually;
import org.infinispan.server.test.core.Containers;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.testcontainers.containers.GenericContainer;

public class RequestTracingIT {
    public static final String JAEGER_IMAGE = System.getProperty("org.infinispan.test.jaegerImage", "quay.io/jaegertracing/all-in-one:1.35.2");
    public static final String SERVICE_NAME = RequestTracingIT.class.getName();
    public static final int NUM_KEYS = 10;
    private static final JaegerAllInOne JAEGER = (JaegerAllInOne)new JaegerAllInOne(JAEGER_IMAGE).withEnv("COLLECTOR_OTLP_ENABLED", "true");
    @ClassRule
    public static final InfinispanServerRule SERVER = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").runMode(ServerRunMode.CONTAINER)).numServers(1)).property("infinispan.tracing.enabled", "true")).property("otel.traces.exporter", "otlp")).property("otel.service.name", SERVICE_NAME)).addListener(new InfinispanServerListener(){

        public void before(InfinispanServerDriver driver) {
            JAEGER.start();
            String endpoint = String.format("http://%s:%s", Containers.ipAddress((GenericContainer)JAEGER), "4317");
            driver.getConfiguration().properties().setProperty("otel.exporter.otlp.endpoint", endpoint);
        }

        public void after(InfinispanServerDriver driver) {
            JAEGER.stop();
        }
    })).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVER);

    @Test
    public void testRequestIsTraced() {
        RemoteCache remoteCache = this.SERVER_TEST.hotrod().create();
        for (int i = 0; i < 10; ++i) {
            remoteCache.put((Object)("key" + i), (Object)"value");
        }
        OkHttpClient httpClient = new OkHttpClient();
        String queryUrl = String.format("http://%s:%s/api/traces?service=%s", Containers.ipAddress((GenericContainer)JAEGER), 16686, SERVICE_NAME);
        Eventually.eventually(() -> {
            try (Response response = httpClient.newCall(new Request.Builder().url(queryUrl).build()).execute();){
                if (response.body() == null) {
                    boolean bl = false;
                    return bl;
                }
                Json json = Json.read((String)response.body().string());
                boolean bl = json.has("data") && !json.at("data").asList().isEmpty();
                return bl;
            }
        });
    }
}

