/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestClient;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.testcontainers.shaded.com.google.common.collect.Sets;

public class RestServerResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testConfig() {
        RestClient client = this.SERVER_TEST.rest().create();
        Json configNode = Json.read((String)Common.assertStatus(200, client.server().configuration()));
        Json server = configNode.at("server");
        Json interfaces = server.at("interfaces");
        Json security = server.at("security");
        Json endpoints = server.at("endpoints");
        Json endpoint = endpoints.at("endpoint");
        String inetAddress = SERVERS.getServerDriver() instanceof ContainerInfinispanServerDriver ? "SITE_LOCAL" : "127.0.0.1";
        Assert.assertEquals((Object)inetAddress, (Object)interfaces.at(0).at("inet-address").at("value").asString());
        Assert.assertEquals((Object)"default", (Object)security.at("security-realms").at(0).at("name").asString());
        Assert.assertEquals((Object)"hotrod", (Object)endpoint.at("hotrod-connector").at("name").asString());
        Assert.assertEquals((Object)"rest", (Object)endpoint.at("rest-connector").at("name").asString());
        Assert.assertEquals((Object)"memcachedCache", (Object)endpoint.at("memcached-connector").at("cache").asString());
    }

    @Test
    public void testThreads() {
        RestClient client = this.SERVER_TEST.rest().create();
        Common.assertResponse(200, client.server().threads(), r -> {
            Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)r.contentType());
            Assert.assertTrue((boolean)r.getBody().contains("state=RUNNABLE"));
        });
    }

    @Test
    public void testInfo() {
        RestClient client = this.SERVER_TEST.rest().create();
        Json infoNode = Json.read((String)Common.assertStatus(200, client.server().info()));
        Assert.assertNotNull((Object)infoNode.at("version"));
    }

    @Test
    public void testMemory() {
        RestClient client = this.SERVER_TEST.rest().create();
        Json infoNode = Json.read((String)Common.assertStatus(200, client.server().memory()));
        Json memory = infoNode.at("heap");
        Assert.assertTrue((memory.at("used").asInteger() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((memory.at("committed").asInteger() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnv() {
        RestClient client = this.SERVER_TEST.rest().create();
        Json infoNode = Json.read((String)Common.assertStatus(200, client.server().env()));
        Json osVersion = infoNode.at("os.version");
        Assert.assertEquals((Object)System.getProperty("os.version"), (Object)osVersion.asString());
    }

    @Test
    public void testCacheManagerNames() {
        RestClient client = this.SERVER_TEST.rest().create();
        Json cacheManagers = Json.read((String)Common.assertStatus(200, client.cacheManagers()));
        Set cmNames = cacheManagers.asJsonList().stream().map(Json::asString).collect(Collectors.toSet());
        Assert.assertEquals(cmNames, (Object)Sets.newHashSet((Object[])new String[]{"default"}));
    }
}

