/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.IOException;
import java.util.List;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.upgrade.SerializationUtils;
import org.infinispan.server.functional.RollingUpgradeIT;
import org.infinispan.server.test.core.Common;
import org.junit.Assert;
import org.junit.Test;

public class RollingUpgradeDynamicStoreIT
extends RollingUpgradeIT {
    public RollingUpgradeDynamicStoreIT() {
        super("configuration/ClusteredServerTest.xml");
    }

    @Override
    @Test
    public void testRollingUpgrade() throws Exception {
        RestClient restClientSource = this.source.getClient();
        RestClient restClientTarget = this.target.getClient();
        this.createSourceClusterCache();
        this.createTargetClusterWithoutStore();
        this.addSchema(restClientSource);
        this.addSchema(restClientTarget);
        this.populateCluster(restClientSource);
        this.assertSourceDisconnected();
        this.connectTargetCluster();
        this.assertSourceConnected();
        Assert.assertEquals((Object)"name-13", (Object)this.getPersonName("13", restClientTarget));
        this.doRollingUpgrade(restClientTarget);
        this.doRollingUpgrade(restClientTarget);
        this.disconnectSource(restClientTarget);
        this.assertSourceDisconnected();
        this.stopSourceCluster();
        for (int i = 0; i < this.target.getMembers().size(); ++i) {
            RestClient restClient = this.target.getClient(i);
            Assert.assertEquals((long)50L, (long)this.getCacheSize("rolling", restClient));
            Assert.assertEquals((Object)"name-35", (Object)this.getPersonName("35", restClient));
        }
    }

    private void createTargetClusterWithoutStore() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.createCache("rolling", builder, this.target.getClient());
    }

    protected void connectTargetCluster() throws IOException {
        RestCacheClient client = this.target.getClient().cache("rolling");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.addRemoteStore(builder);
        RemoteStoreConfiguration remoteStore = (RemoteStoreConfiguration)builder.build().persistence().stores().iterator().next();
        RestEntity restEntity = RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)SerializationUtils.toJson((RemoteStoreConfiguration)remoteStore));
        Common.assertStatus(204, client.connectSource(restEntity));
        String json = Common.assertStatus(200, client.sourceConnection());
        RemoteStoreConfiguration remoteStoreConfiguration = SerializationUtils.fromJson((String)json);
        List servers = remoteStoreConfiguration.servers();
        Assert.assertEquals((long)1L, (long)servers.size());
        RemoteServerConfiguration initialConfig = (RemoteServerConfiguration)remoteStore.servers().iterator().next();
        Assert.assertEquals((Object)initialConfig.host(), (Object)((RemoteServerConfiguration)servers.get(0)).host());
        Assert.assertEquals((long)initialConfig.port(), (long)((RemoteServerConfiguration)servers.get(0)).port());
    }

    protected void assertSourceConnected() {
        Common.assertStatus(200, this.target.getClient().cache("rolling").sourceConnected());
    }

    protected void assertSourceDisconnected() {
        Common.assertStatus(404, this.target.getClient().cache("rolling").sourceConnected());
    }
}

