/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional.protobuf;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.functional.protobuf.Person;
import org.infinispan.server.functional.protobuf.QuerySchemaBuilderImpl;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ProtobufHotRodRestEntityIT {
    private static final String CACHE_NAME = "test";
    private static final String CACHE_CONFIG = "<distributed-cache name=\"CACHE_NAME\">\n    <encoding media-type=\"application/x-protostream\"/>\n</distributed-cache>";
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/BasicServerTest.xml").runMode(ServerRunMode.FORKED)).numServers(1)).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void test() {
        RemoteCacheManager hotRodClient = ProtobufHotRodRestEntityIT.getHotRodClient();
        try {
            ProtobufHotRodRestEntityIT.testQueries(hotRodClient);
        }
        finally {
            hotRodClient.stop();
        }
        RestClient restClient = this.SERVER_TEST.rest().create();
        RestResponse response = (RestResponse)Common.sync(restClient.cache(CACHE_NAME).entries(1000));
        if (response.getStatus() != 200) {
            Assertions.fail((String)response.getBody());
        }
        Collection entities = (Collection)Json.read((String)response.getBody()).getValue();
        Assertions.assertThat((Iterable)entities).hasSize(4);
    }

    private static void testQueries(RemoteCacheManager client) {
        RemoteCache peopleCache = client.getCache(CACHE_NAME);
        HashMap<String, Person> people = new HashMap<String, Person>();
        people.put("1", new Person("Oihana", "Rossignol", 2016, "Paris"));
        people.put("2", new Person("Elaia", "Rossignol", 2018, "Paris"));
        people.put("3", new Person("Yago", "Steiner", 2013, "Saint-Mand\u00e9"));
        people.put("4", new Person("Alberto", "Steiner", 2016, "Paris"));
        peopleCache.putAll(people);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)peopleCache);
        Query query = queryFactory.create("FROM tutorial.Person p where p.lastName = :lastName");
        query.setParameter("lastName", (Object)"Rossignol");
        List rossignols = query.execute().list();
        Assertions.assertThat((List)rossignols).extracting("firstName").containsExactlyInAnyOrder(new Object[]{"Oihana", "Elaia"});
    }

    private static RemoteCacheManager getHotRodClient() {
        QuerySchemaBuilderImpl schema = new QuerySchemaBuilderImpl();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.remoteCache(CACHE_NAME).configuration(CACHE_CONFIG.replace("CACHE_NAME", CACHE_NAME));
        builder.addContextInitializer((SerializationContextInitializer)schema);
        RemoteCacheManager client = new RemoteCacheManager(builder.build());
        RemoteCache metadataCache = client.getCache("___protobuf_metadata");
        metadataCache.put((Object)schema.getProtoFileName(), (Object)schema.getProtoFile());
        return client;
    }
}

