/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import com.mysql.cj.jdbc.AbandonedConnectionCleanupThread;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.impl.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;

public class TableManipulation
implements AutoCloseable {
    private ConnectionFactory connectionFactory;
    private Connection connection;
    public PooledConnectionFactoryConfigurationBuilder persistenceConfiguration;
    private final String countRowsSql;
    private final String selectIdRowSqlWithLike;
    private static final String ID_COLUMN_NAME = "id";
    private static final String DEFAULT_IDENTIFIER_QUOTE_STRING = "\"";
    private static final String TABLE_NAME_PREFIX = "tbl";
    private String tableName;

    public TableManipulation(String cacheName, PooledConnectionFactoryConfigurationBuilder persistenceConfiguration, ConfigurationBuilder configurationBuilder) {
        this.persistenceConfiguration = persistenceConfiguration;
        this.tableName = String.format("%s%s_%s%s", DEFAULT_IDENTIFIER_QUOTE_STRING, TABLE_NAME_PREFIX, cacheName, DEFAULT_IDENTIFIER_QUOTE_STRING);
        if (this.isMysql()) {
            this.tableName = this.tableName.replaceAll(DEFAULT_IDENTIFIER_QUOTE_STRING, "");
        }
        this.countRowsSql = "SELECT COUNT(*) FROM " + this.tableName;
        this.selectIdRowSqlWithLike = String.format("SELECT %s FROM %s WHERE %s LIKE ?", ID_COLUMN_NAME, this.tableName, ID_COLUMN_NAME);
    }

    private ConnectionFactory getConnectionFactory() {
        PooledConnectionFactoryConfiguration pooledConnectionFactoryConfiguration = this.persistenceConfiguration.create();
        this.connectionFactory = ConnectionFactory.getConnectionFactory(PooledConnectionFactory.class);
        this.connectionFactory.start((ConnectionFactoryConfiguration)pooledConnectionFactoryConfiguration, this.connectionFactory.getClass().getClassLoader());
        return this.connectionFactory;
    }

    private Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.getConnectionFactory().getConnection();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueByKey(String key) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            String string;
            Connection connection = this.getConnection();
            ps = null;
            rs = null;
            try {
                ps = connection.prepareStatement(this.selectIdRowSqlWithLike);
                ps.setString(1, "%" + this.getEncodedKey(key) + "%");
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                string = rs.getString("ID");
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(ps);
                JdbcUtil.safeClose(rs);
                throw throwable;
            }
            JdbcUtil.safeClose((Statement)ps);
            JdbcUtil.safeClose((ResultSet)rs);
            return string;
        }
        String string = null;
        JdbcUtil.safeClose((Statement)ps);
        JdbcUtil.safeClose((ResultSet)rs);
        return string;
    }

    public int countAllRows() throws Exception {
        this.connection = this.getConnection();
        try (PreparedStatement ps = this.connection.prepareStatement(this.countRowsSql);){
            int n;
            block16: {
                ResultSet rs;
                block14: {
                    int n2;
                    block15: {
                        rs = ps.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            n2 = rs.getInt(1);
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return n2;
                }
                n = 0;
                if (rs == null) break block16;
                rs.close();
            }
            return n;
        }
    }

    public String getEncodedKey(String key) throws Exception {
        ProtoStreamMarshaller protoStreamMarshaller = new ProtoStreamMarshaller();
        byte[] marshalled = protoStreamMarshaller.objectToByteBuffer((Object)key);
        DefaultTwoWayKey2StringMapper mapper = new DefaultTwoWayKey2StringMapper();
        return mapper.getStringMapping((Object)new WrappedByteArray(marshalled));
    }

    private void deregisterDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            try {
                Driver driver = drivers.nextElement();
                if (driver instanceof com.mysql.cj.jdbc.Driver) {
                    AbandonedConnectionCleanupThread.checkedShutdown();
                }
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean isMysql() {
        try {
            this.connection = this.getConnection();
            String dbProduct = this.connection.getMetaData().getDatabaseProductName();
            DatabaseType databaseType = DatabaseType.guessDialect((String)dbProduct);
            if (databaseType == DatabaseType.MYSQL) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            JdbcUtil.safeClose((Connection)this.connection);
            this.connectionFactory.stop();
            this.connectionFactory.releaseConnection(this.connection);
        }
        this.deregisterDrivers();
    }
}

