/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resilience;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.core.category.Resilience;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Resilience.class})
public class ResilienceMaxRetryIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").runMode(ServerRunMode.EMBEDDED)).numServers(3)).build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testMaxRetries0() {
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(new ConfigurationBuilder().maxRetries(0).connectionTimeout(500)).withCacheMode(CacheMode.REPL_SYNC)).create(0);
        cache.get((Object)ThreadLocalRandom.current().nextInt());
        InetSocketAddress serverAddress0 = SERVERS.getServerDriver().getServerSocket(0, SERVERS.getTestServer().getDefaultPortNumber());
        InetSocketAddress serverAddress1 = SERVERS.getServerDriver().getServerSocket(1, SERVERS.getTestServer().getDefaultPortNumber());
        InetSocketAddress serverAddress2 = SERVERS.getServerDriver().getServerSocket(2, SERVERS.getTestServer().getDefaultPortNumber());
        SERVERS.getServerDriver().stop(0);
        byte[] cacheNameBytes = cache.getName().getBytes();
        for (int i = 0; i < 10; ++i) {
            try {
                cache.get((Object)ThreadLocalRandom.current().nextInt());
                break;
            }
            catch (TransportException e) {
                Assert.assertTrue((String)(serverAddress0.toString() + " not found in " + e.getMessage()), (boolean)e.getMessage().contains(serverAddress0.toString()));
                continue;
            }
        }
        Collection currentServers = cache.getRemoteCacheManager().getChannelFactory().getServers(cacheNameBytes);
        Assert.assertEquals(new HashSet<InetSocketAddress>(Arrays.asList(serverAddress1, serverAddress2)), new HashSet<InetSocketAddress>(this.resolveAddresses(currentServers)));
        SERVERS.getServerDriver().stop(1);
        SERVERS.getServerDriver().stop(2);
        SERVERS.getServerDriver().restart(0);
        for (int i = 0; i < 10; ++i) {
            try {
                cache.get((Object)ThreadLocalRandom.current().nextInt());
                break;
            }
            catch (TransportException e) {
                Assert.assertTrue((String)e.getMessage(), (e.getMessage().contains(serverAddress1.toString()) || e.getMessage().contains(serverAddress2.toString()) ? 1 : 0) != 0);
                continue;
            }
        }
        currentServers = cache.getRemoteCacheManager().getChannelFactory().getServers(cacheNameBytes);
        Assert.assertEquals(Collections.singletonList(serverAddress0), this.resolveAddresses(currentServers));
        cache.get((Object)ThreadLocalRandom.current().nextInt());
    }

    private Collection<InetSocketAddress> resolveAddresses(Collection<InetSocketAddress> serverAddresses) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(serverAddresses.size());
        for (InetSocketAddress serverAddress : serverAddresses) {
            list.add(new InetSocketAddress(serverAddress.getHostString(), serverAddress.getPort()));
        }
        return list;
    }
}

